/*
 * Decompiled with CFR 0.152.
 */
package com.nulabinc.zxcvbn;

import com.nulabinc.zxcvbn.matchers.Dictionary;
import com.nulabinc.zxcvbn.matchers.Match;
import com.nulabinc.zxcvbn.matchers.OmnibusMatcher;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Matching {
    private static final Map<String, Map<String, Integer>> BASE_RANKED_DICTIONARIES = new HashMap<String, Map<String, Integer>>();
    private final Map<String, Map<String, Integer>> rankedDictionaries;

    public Matching() {
        this(new ArrayList<String>());
    }

    public Matching(List<String> orderedList) {
        if (orderedList == null) {
            orderedList = new ArrayList<String>();
        }
        this.rankedDictionaries = new HashMap<String, Map<String, Integer>>();
        for (Map.Entry<String, Map<String, Integer>> baseRankedDictionary : BASE_RANKED_DICTIONARIES.entrySet()) {
            this.rankedDictionaries.put(baseRankedDictionary.getKey(), baseRankedDictionary.getValue());
        }
        this.rankedDictionaries.put("user_inputs", Matching.buildRankedDict(orderedList.toArray(new String[0])));
    }

    public List<Match> omnimatch(String password) {
        return new OmnibusMatcher(this.rankedDictionaries).execute(password);
    }

    private static Map<String, Integer> buildRankedDict(String[] orderedList) {
        HashMap<String, Integer> result = new HashMap<String, Integer>();
        int i = 1;
        for (String word : orderedList) {
            result.put(word, i);
            ++i;
        }
        return result;
    }

    static {
        for (Map.Entry<String, String[]> frequencyListRef : Dictionary.FREQUENCY_LISTS.entrySet()) {
            String name = frequencyListRef.getKey();
            String[] ls = frequencyListRef.getValue();
            BASE_RANKED_DICTIONARIES.put(name, Matching.buildRankedDict(ls));
        }
    }
}

