/*
 * Decompiled with CFR 0.152.
 */
package org.jets3t.service.io;

import java.io.IOException;
import java.io.OutputStream;
import org.jets3t.service.io.BytesProgressWatcher;
import org.jets3t.service.io.OutputStreamWrapper;

public class ProgressMonitoredOutputStream
extends OutputStream
implements OutputStreamWrapper {
    private OutputStream outputStream = null;
    private BytesProgressWatcher progressWatcher = null;

    public ProgressMonitoredOutputStream(OutputStream outputStream, BytesProgressWatcher progressWatcher) {
        if (outputStream == null) {
            throw new IllegalArgumentException("ProgressMonitoredOutputStream cannot run with a null OutputStream");
        }
        this.outputStream = outputStream;
        this.progressWatcher = progressWatcher;
    }

    public void sendNotificationUpdate(long bytesTransmitted) {
        this.progressWatcher.updateBytesTransferred(bytesTransmitted);
    }

    public void resetProgressMonitor() {
        this.progressWatcher.resetWatcher();
    }

    @Override
    public void write(int b) throws IOException {
        this.outputStream.write(b);
        this.sendNotificationUpdate(1L);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.outputStream.write(b, off, len);
        this.sendNotificationUpdate(len - off);
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.outputStream.write(b.length);
        this.sendNotificationUpdate(b.length);
    }

    @Override
    public void close() throws IOException {
        this.outputStream.close();
    }

    @Override
    public OutputStream getWrappedOutputStream() {
        return this.outputStream;
    }
}

