/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.date;

import ch.cyberduck.core.date.DateDomainService;
import ch.cyberduck.core.date.Instant;
import java.util.Calendar;
import java.util.TimeZone;
import org.apache.log4j.Logger;

public class CalendarService
implements DateDomainService<Calendar> {
    private static final Logger log = Logger.getLogger(CalendarService.class);
    private final TimeZone tz;

    public CalendarService(TimeZone tz) {
        this.tz = null == tz ? TimeZone.getTimeZone("UTC") : tz;
    }

    @Override
    public Calendar asDate(long timestamp, Instant precision) {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Convert timestamp %d to calendar with precision %s", new Object[]{timestamp, precision}));
        }
        Calendar c = Calendar.getInstance(this.tz);
        c.setTimeInMillis(timestamp);
        if (precision == Instant.MILLISECOND) {
            return c;
        }
        c.clear(14);
        if (precision == Instant.SECOND) {
            return c;
        }
        c.clear(13);
        if (precision == Instant.MINUTE) {
            return c;
        }
        c.clear(12);
        if (precision == Instant.HOUR) {
            return c;
        }
        c.clear(10);
        return c;
    }
}

