/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core;

import ch.cyberduck.core.DescriptiveUrl;
import ch.cyberduck.core.DescriptiveUrlBag;
import ch.cyberduck.core.Host;
import ch.cyberduck.core.LocaleFactory;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathNormalizer;
import ch.cyberduck.core.PathRelativizer;
import ch.cyberduck.core.URIEncoder;
import ch.cyberduck.core.UrlProvider;
import java.net.URI;
import java.text.MessageFormat;
import org.apache.commons.lang3.StringUtils;

public class WebUrlProvider
implements UrlProvider {
    private final Host host;

    public WebUrlProvider(Host host) {
        this.host = host;
    }

    @Override
    public DescriptiveUrlBag toUrl(Path file) {
        DescriptiveUrlBag list = new DescriptiveUrlBag();
        DescriptiveUrl base = this.toUrl();
        list.add(new DescriptiveUrl(URI.create(String.format("%s%s", base.getUrl(), URIEncoder.encode(PathNormalizer.normalize(PathRelativizer.relativize(PathNormalizer.normalize(this.host.getDefaultPath(), true), file.getAbsolute()))))).normalize(), base.getType(), base.getHelp()));
        return list;
    }

    public DescriptiveUrl toUrl() {
        String base;
        if (StringUtils.isBlank((CharSequence)this.host.getWebURL())) {
            switch (this.host.getProtocol().getScheme()) {
                case https: {
                    base = String.format("https://%s/", StringUtils.strip((String)this.host.getHostname()));
                    break;
                }
                default: {
                    base = String.format("http://%s/", StringUtils.strip((String)this.host.getHostname()));
                    break;
                }
            }
        } else {
            base = this.host.getWebURL().matches("^http(s)?://.*$") ? this.host.getWebURL() : String.format("http://%s/", this.host.getWebURL());
        }
        URI uri = URI.create(base);
        return new DescriptiveUrl(uri, DescriptiveUrl.Type.http, MessageFormat.format(LocaleFactory.localizedString("{0} URL"), StringUtils.upperCase((String)uri.getScheme())));
    }
}

