/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.StringTokenizer;
import org.apache.commons.lang3.StringUtils;

public final class URIEncoder {
    private URIEncoder() {
    }

    public static String encode(String p) {
        try {
            StringBuilder b = new StringBuilder();
            StringTokenizer t = new StringTokenizer(p, "/");
            if (!t.hasMoreTokens()) {
                return p;
            }
            if (StringUtils.startsWith((CharSequence)p, (CharSequence)String.valueOf('/'))) {
                b.append('/');
            }
            while (t.hasMoreTokens()) {
                b.append(URLEncoder.encode(t.nextToken(), "UTF-8"));
                if (!t.hasMoreTokens()) continue;
                b.append('/');
            }
            if (StringUtils.endsWith((CharSequence)p, (CharSequence)String.valueOf('/'))) {
                b.append('/');
            }
            return StringUtils.replaceEach((String)b.toString(), (String[])new String[]{"+", "*", "%7E", "%40"}, (String[])new String[]{"%20", "%2A", "~", "@"});
        }
        catch (UnsupportedEncodingException e) {
            return p;
        }
    }
}

