/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.oauth;

import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.http.DisabledServiceUnavailableRetryStrategy;
import ch.cyberduck.core.oauth.OAuth2RequestInterceptor;
import org.apache.http.HttpResponse;
import org.apache.http.protocol.HttpContext;
import org.apache.log4j.Logger;

public class OAuth2ErrorResponseInterceptor
extends DisabledServiceUnavailableRetryStrategy {
    private static final Logger log = Logger.getLogger(OAuth2ErrorResponseInterceptor.class);
    private static final int MAX_RETRIES = 1;
    private final OAuth2RequestInterceptor service;

    public OAuth2ErrorResponseInterceptor(OAuth2RequestInterceptor service) {
        this.service = service;
    }

    public boolean retryRequest(HttpResponse response, int executionCount, HttpContext context) {
        switch (response.getStatusLine().getStatusCode()) {
            case 401: {
                if (executionCount > 1) break;
                try {
                    log.info((Object)String.format("Attempt to refresh OAuth tokens for failure %s", response));
                    this.service.setTokens(this.service.refresh());
                    return true;
                }
                catch (BackgroundException e) {
                    log.warn((Object)String.format("Failure refreshing OAuth tokens. %s", e.getDetail()));
                    return false;
                }
            }
        }
        return false;
    }
}

