/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.sds;

import ch.cyberduck.core.Cache;
import ch.cyberduck.core.ConnectionCallback;
import ch.cyberduck.core.DisabledListProgressListener;
import ch.cyberduck.core.ListProgressListener;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathAttributes;
import ch.cyberduck.core.Session;
import ch.cyberduck.core.VersionId;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.AttributesFinder;
import ch.cyberduck.core.features.Find;
import ch.cyberduck.core.features.Write;
import ch.cyberduck.core.http.AbstractHttpWriteFeature;
import ch.cyberduck.core.http.DelayedHttpEntity;
import ch.cyberduck.core.http.DelayedHttpEntityCallable;
import ch.cyberduck.core.http.DelayedHttpMultipartEntity;
import ch.cyberduck.core.http.HttpExceptionMappingService;
import ch.cyberduck.core.http.HttpResponseOutputStream;
import ch.cyberduck.core.io.ChecksumCompute;
import ch.cyberduck.core.io.DisabledChecksumCompute;
import ch.cyberduck.core.sds.SDSApiClient;
import ch.cyberduck.core.sds.SDSExceptionMappingService;
import ch.cyberduck.core.sds.SDSNodeIdProvider;
import ch.cyberduck.core.sds.SDSSession;
import ch.cyberduck.core.sds.io.swagger.client.ApiClient;
import ch.cyberduck.core.sds.io.swagger.client.ApiException;
import ch.cyberduck.core.sds.io.swagger.client.api.NodesApi;
import ch.cyberduck.core.sds.io.swagger.client.model.CompleteUploadRequest;
import ch.cyberduck.core.sds.io.swagger.client.model.CreateFileUploadRequest;
import ch.cyberduck.core.sds.io.swagger.client.model.CreateFileUploadResponse;
import ch.cyberduck.core.sds.io.swagger.client.model.FileKey;
import ch.cyberduck.core.sds.triplecrypt.CryptoExceptionMappingService;
import ch.cyberduck.core.sds.triplecrypt.TripleCryptConverter;
import ch.cyberduck.core.shared.DefaultAttributesFinderFeature;
import ch.cyberduck.core.shared.DefaultFindFeature;
import ch.cyberduck.core.transfer.TransferStatus;
import com.dracoon.sdk.crypto.Crypto;
import com.dracoon.sdk.crypto.CryptoSystemException;
import com.dracoon.sdk.crypto.InvalidFileKeyException;
import com.dracoon.sdk.crypto.InvalidKeyPairException;
import com.dracoon.sdk.crypto.model.PlainFileKey;
import com.dracoon.sdk.crypto.model.UserPublicKey;
import java.io.IOException;
import java.util.Collections;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.AbstractHttpEntity;
import org.apache.http.entity.BufferedHttpEntity;
import org.apache.http.util.EntityUtils;

public class SDSWriteFeature
extends AbstractHttpWriteFeature<VersionId> {
    private final SDSSession session;
    private final SDSNodeIdProvider nodeid;
    private final Find finder;
    private final AttributesFinder attributes;
    public static final CreateFileUploadRequest.ClassificationEnum DEFAULT_CLASSIFICATION = CreateFileUploadRequest.ClassificationEnum.NUMBER_1;

    public SDSWriteFeature(SDSSession session, SDSNodeIdProvider nodeid) {
        this(session, nodeid, (Find)new DefaultFindFeature((Session)session), (AttributesFinder)new DefaultAttributesFinderFeature((Session)session));
    }

    public SDSWriteFeature(SDSSession session, SDSNodeIdProvider nodeid, Find finder, AttributesFinder attributes) {
        super(finder, attributes);
        this.session = session;
        this.nodeid = nodeid;
        this.finder = finder;
        this.attributes = attributes;
    }

    public HttpResponseOutputStream<VersionId> write(final Path file, final TransferStatus status, ConnectionCallback callback) throws BackgroundException {
        CreateFileUploadRequest body = new CreateFileUploadRequest();
        body.setParentId(Long.parseLong(this.nodeid.getFileid(file.getParent(), (ListProgressListener)new DisabledListProgressListener())));
        body.setName(file.getName());
        body.classification(DEFAULT_CLASSIFICATION);
        try {
            CreateFileUploadResponse response = new NodesApi((ApiClient)this.session.getClient()).createFileUpload(body, "");
            final String uploadId = response.getUploadId();
            final DelayedHttpMultipartEntity entity = new DelayedHttpMultipartEntity(file.getName(), status);
            DelayedHttpEntityCallable<VersionId> command = new DelayedHttpEntityCallable<VersionId>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Unable to fully structure code
                 */
                public VersionId call(AbstractHttpEntity entity) throws BackgroundException {
                    try {
                        client = (SDSApiClient)SDSWriteFeature.access$000(SDSWriteFeature.this).getClient();
                        request = new HttpPost(String.format("%s/v4/nodes/files/uploads/%s", new Object[]{client.getBasePath(), uploadId}));
                        request.setEntity((HttpEntity)entity);
                        request.setHeader("X-Sds-Auth-Token", "");
                        request.setHeader("Content-Type", String.format("multipart/form-data; boundary=%s", new Object[]{"------------------------d8ad73fe428d737a"}));
                        response = client.getClient().execute((HttpUriRequest)request);
                        try {
                            switch (response.getStatusLine().getStatusCode()) {
                                case 201: {
                                    ** break;
lbl12:
                                    // 1 sources

                                    break;
                                }
                                default: {
                                    EntityUtils.updateEntity((HttpResponse)response, (HttpEntity)new BufferedHttpEntity(response.getEntity()));
                                    throw new SDSExceptionMappingService().map(new ApiException(response.getStatusLine().getStatusCode(), response.getStatusLine().getReasonPhrase(), Collections.emptyMap(), EntityUtils.toString((HttpEntity)response.getEntity())));
                                }
                            }
                        }
                        finally {
                            EntityUtils.consume((HttpEntity)response.getEntity());
                        }
                        body = new CompleteUploadRequest();
                        body.setResolutionStrategy(CompleteUploadRequest.ResolutionStrategyEnum.OVERWRITE);
                        if (status.getFilekey() != null) {
                            reader = ((SDSApiClient)SDSWriteFeature.access$000(SDSWriteFeature.this).getClient()).getJSON().getContext(null).readerFor(FileKey.class);
                            fileKey = (FileKey)reader.readValue(status.getFilekey().array());
                            encryptFileKey = Crypto.encryptFileKey((PlainFileKey)TripleCryptConverter.toCryptoPlainFileKey(fileKey), (UserPublicKey)TripleCryptConverter.toCryptoUserPublicKey(SDSWriteFeature.access$000(SDSWriteFeature.this).keyPair().getPublicKeyContainer()));
                            body.setFileKey(TripleCryptConverter.toSwaggerFileKey(encryptFileKey));
                        }
                        upload = new NodesApi(client).completeFileUpload(uploadId, body, "", null);
                        return new VersionId(String.valueOf(upload.getId()));
                    }
                    catch (IOException e) {
                        throw new HttpExceptionMappingService().map("Upload {0} failed", (Throwable)e, file);
                    }
                    catch (ApiException e) {
                        throw new SDSExceptionMappingService().map("Upload {0} failed", e, file);
                    }
                    catch (CryptoSystemException | InvalidFileKeyException | InvalidKeyPairException e) {
                        throw new CryptoExceptionMappingService().map("Upload {0} failed", e, file);
                    }
                }

                public long getContentLength() {
                    return entity.getContentLength();
                }
            };
            return this.write(file, status, (DelayedHttpEntityCallable)command, (DelayedHttpEntity)entity);
        }
        catch (ApiException e) {
            throw new SDSExceptionMappingService().map("Upload {0} failed", e, file);
        }
    }

    public boolean temporary() {
        return false;
    }

    public boolean random() {
        return false;
    }

    public ChecksumCompute checksum(Path file) {
        return new DisabledChecksumCompute();
    }

    public Write.Append append(Path file, Long length, Cache<Path> cache) throws BackgroundException {
        if (this.finder.withCache(cache).find(file)) {
            PathAttributes attributes = this.attributes.withCache(cache).find(file);
            return new Write.Append(false, true).withSize(Long.valueOf(attributes.getSize())).withChecksum(attributes.getChecksum());
        }
        return Write.notfound;
    }

    static /* synthetic */ SDSSession access$000(SDSWriteFeature x0) {
        return x0.session;
    }
}

