/*
 * Decompiled with CFR 0.152.
 */
package com.twmacinta.util;

import com.twmacinta.util.MD5;
import com.twmacinta.util.MD5State;
import java.nio.ByteBuffer;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.digests.EncodableDigest;
import org.bouncycastle.util.Memoable;

public class FastMD5Digest
implements Digest,
EncodableDigest,
Memoable {
    private static final int DIGEST_LENGTH = 16;
    private final MD5 md5 = new MD5();

    public FastMD5Digest() {
    }

    public FastMD5Digest(byte[] encodedState) {
        FastMD5Digest.updateStateFromEncodedState(this.md5.state, encodedState);
    }

    private FastMD5Digest(MD5State state) {
        this.md5.state = state;
    }

    public String getAlgorithmName() {
        return "MD5";
    }

    public int getDigestSize() {
        return 16;
    }

    public void update(byte in) {
        this.md5.Update(in);
    }

    public void update(byte[] in, int inOff, int len) {
        this.md5.Update(in, inOff, len);
    }

    public int doFinal(byte[] out, int outOff) {
        byte[] finalValue = this.md5.Final();
        System.arraycopy(finalValue, 0, out, outOff, finalValue.length);
        return 16;
    }

    public void reset() {
        this.md5.Init();
    }

    public byte[] getEncodedState() {
        MD5State state = this.md5.state;
        return FastMD5Digest.generateEncodedState(state);
    }

    public Memoable copy() {
        MD5State state = new MD5State(this.md5.state);
        return new FastMD5Digest(state);
    }

    public void reset(Memoable other) {
        if (!other.getClass().equals(FastMD5Digest.class)) {
            throw new UnsupportedOperationException("Reset is only supported from another FastMD5Digest class");
        }
        FastMD5Digest d = (FastMD5Digest)other;
        this.md5.state = new MD5State(d.md5.state);
    }

    static byte[] generateEncodedState(MD5State md5State) {
        int stateBufferSize = md5State.buffer.length + 4 + md5State.state.length * 4 + 4 + 8;
        ByteBuffer bytes = ByteBuffer.allocate(stateBufferSize);
        bytes.putInt(md5State.buffer.length);
        bytes.put(md5State.buffer);
        bytes.putInt(md5State.state.length);
        for (int i : md5State.state) {
            bytes.putInt(i);
        }
        bytes.putLong(md5State.count);
        return bytes.array();
    }

    static void updateStateFromEncodedState(MD5State md5State, byte[] encodedState) {
        ByteBuffer bytes = ByteBuffer.wrap(encodedState);
        byte[] buffer = new byte[bytes.getInt()];
        bytes.get(buffer);
        int[] state = new int[bytes.getInt()];
        for (int i = 0; i < state.length; ++i) {
            state[i] = bytes.getInt();
        }
        long count = bytes.getLong();
        md5State.buffer = buffer;
        md5State.state = state;
        md5State.count = count;
    }
}

