/*
 * Decompiled with CFR 0.152.
 */
package com.joyent.manta.client;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.joyent.manta.client.MantaObjectMapper;
import com.joyent.manta.exception.MantaObjectException;
import com.joyent.manta.http.HttpHelper;
import com.joyent.manta.util.MantaUtils;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UncheckedIOException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.Validate;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;

public class MantaDirectoryListingIterator
implements Iterator<Map<String, Object>>,
AutoCloseable {
    private final int pagingSize;
    private final String path;
    private final HttpHelper httpHelper;
    private final AtomicLong lines = new AtomicLong(0L);
    private final AtomicReference<String> nextLine = new AtomicReference();
    private final AtomicBoolean finished = new AtomicBoolean(false);
    private final ObjectMapper mapper = MantaObjectMapper.INSTANCE;
    private volatile String lastMarker;
    private volatile BufferedReader br;
    private volatile CloseableHttpResponse currentResponse;

    @Deprecated
    public MantaDirectoryListingIterator(String url, String path, HttpHelper httpHelper, int pagingSize) {
        this(path, httpHelper, pagingSize);
    }

    public MantaDirectoryListingIterator(String path, HttpHelper httpHelper, int pagingSize) {
        Validate.notBlank((CharSequence)path, (String)"Path must not be blank", (Object[])new Object[0]);
        Validate.notNull((Object)httpHelper, (String)"HTTP help must not be null", (Object[])new Object[0]);
        this.path = path;
        this.httpHelper = httpHelper;
        if (pagingSize < 2) {
            throw new IllegalArgumentException("Paging size must be greater than 1 and less than or equal to 1024");
        }
        this.pagingSize = pagingSize;
    }

    private synchronized void selectReader() throws IOException {
        String results;
        HttpGet request;
        String query;
        if (this.lastMarker == null) {
            query = String.format("?limit=%d", this.pagingSize);
            request = this.httpHelper.getRequestFactory().get(MantaUtils.formatPath(this.path) + query);
            IOUtils.closeQuietly((Closeable)this.currentResponse);
            this.currentResponse = this.httpHelper.executeRequest((HttpUriRequest)request, null, new Object[0]);
            HttpEntity entity = this.currentResponse.getEntity();
            String contentType = entity.getContentType().getValue();
            if (!contentType.equals("application/x-json-stream; type=directory")) {
                String msg = String.format("Expected directory path, but was file path: %s", this.path);
                throw new MantaObjectException(msg);
            }
            InputStreamReader streamReader = new InputStreamReader(entity.getContent(), StandardCharsets.UTF_8.name());
            this.br = new BufferedReader(streamReader);
        } else {
            query = String.format("?limit=%d&marker=%s", this.pagingSize, URLEncoder.encode(this.lastMarker, "UTF-8"));
            request = this.httpHelper.getRequestFactory().get(MantaUtils.formatPath(this.path) + query);
            IOUtils.closeQuietly((Reader)this.br);
            IOUtils.closeQuietly((Closeable)this.currentResponse);
            this.currentResponse = this.httpHelper.executeRequest((HttpUriRequest)request, null, new Object[0]);
            HttpEntity entity = this.currentResponse.getEntity();
            InputStreamReader streamReader = new InputStreamReader(entity.getContent(), StandardCharsets.UTF_8.name());
            this.br = new BufferedReader(streamReader);
            this.br.readLine();
        }
        Header resultsHeader = this.currentResponse.getFirstHeader("result-set-size");
        if (resultsHeader != null && (results = resultsHeader.getValue()).equals("0")) {
            this.finished.set(true);
            return;
        }
        this.nextLine.set(this.br.readLine());
        this.lines.incrementAndGet();
        this.finished.set(this.nextLine.get() == null);
    }

    @Override
    public boolean hasNext() {
        if (!this.finished.get() && this.nextLine.get() == null) {
            try {
                this.selectReader();
                return !this.finished.get();
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
        return !this.finished.get();
    }

    @Override
    public synchronized Map<String, Object> next() {
        if (this.finished.get()) {
            throw new NoSuchElementException();
        }
        try {
            String line = this.nextLine.getAndSet(this.br.readLine());
            this.lines.incrementAndGet();
            if (line == null) {
                this.selectReader();
                if (this.finished.get()) {
                    throw new NoSuchElementException();
                }
                line = this.nextLine.getAndSet(this.br.readLine());
            }
            Map lookup = (Map)this.mapper.readValue(line, (TypeReference)new TypeReference<Map<String, Object>>(){});
            String name = Objects.toString(lookup.get("name"));
            Validate.notNull((Object)name, (String)"Name must not be null in JSON input", (Object[])new Object[0]);
            lookup.put("path", this.path);
            this.lastMarker = name;
            return lookup;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public void close() {
        this.finished.set(true);
        IOUtils.closeQuietly((Reader)this.br);
        IOUtils.closeQuietly((Closeable)this.currentResponse);
    }

    public long getLines() {
        return this.lines.get();
    }
}

