/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.manta;

import ch.cyberduck.core.DescriptiveUrl;
import ch.cyberduck.core.DescriptiveUrlBag;
import ch.cyberduck.core.LocaleFactory;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.UrlProvider;
import ch.cyberduck.core.UserDateFormatterFactory;
import ch.cyberduck.core.manta.MantaSession;
import com.joyent.manta.client.MantaClient;
import java.io.IOException;
import java.text.MessageFormat;
import java.time.Duration;
import java.time.temporal.TemporalAmount;
import org.apache.log4j.Logger;

public class MantaUrlProviderFeature
implements UrlProvider {
    private static final Logger log = Logger.getLogger(MantaUrlProviderFeature.class);
    private final MantaSession session;

    public MantaUrlProviderFeature(MantaSession session) {
        this.session = session;
    }

    public DescriptiveUrlBag toUrl(Path file) {
        DescriptiveUrlBag list = new DescriptiveUrlBag();
        if (file.attributes().getLink() != null) {
            list.add(file.attributes().getLink());
        }
        try {
            Duration expiresIn = Duration.ofMinutes(1L);
            list.add(new DescriptiveUrl(((MantaClient)this.session.getClient()).getAsSignedURI(file.getAbsolute(), "GET", (TemporalAmount)expiresIn), DescriptiveUrl.Type.signed, MessageFormat.format(LocaleFactory.localizedString((String)"{0} URL"), LocaleFactory.localizedString((String)"Pre-Signed", (String)"S3")) + " (" + MessageFormat.format(LocaleFactory.localizedString((String)"Expires {0}", (String)"S3") + ")", UserDateFormatterFactory.get().getMediumFormat(System.currentTimeMillis() + expiresIn.toMillis()))));
            expiresIn = Duration.ofHours(1L);
            list.add(new DescriptiveUrl(((MantaClient)this.session.getClient()).getAsSignedURI(file.getAbsolute(), "GET", (TemporalAmount)expiresIn), DescriptiveUrl.Type.signed, MessageFormat.format(LocaleFactory.localizedString((String)"{0} URL"), LocaleFactory.localizedString((String)"Pre-Signed", (String)"S3")) + " (" + MessageFormat.format(LocaleFactory.localizedString((String)"Expires {0}", (String)"S3") + ")", UserDateFormatterFactory.get().getMediumFormat(System.currentTimeMillis() + expiresIn.toMillis()))));
            expiresIn = Duration.ofDays(1L);
            list.add(new DescriptiveUrl(((MantaClient)this.session.getClient()).getAsSignedURI(file.getAbsolute(), "GET", (TemporalAmount)expiresIn), DescriptiveUrl.Type.signed, MessageFormat.format(LocaleFactory.localizedString((String)"{0} URL"), LocaleFactory.localizedString((String)"Pre-Signed", (String)"S3")) + " (" + MessageFormat.format(LocaleFactory.localizedString((String)"Expires {0}", (String)"S3") + ")", UserDateFormatterFactory.get().getMediumFormat(System.currentTimeMillis() + expiresIn.toMillis()))));
        }
        catch (IOException e) {
            log.warn((Object)String.format("Failure creating signed URL for file %s. %s", file, e.getMessage()));
        }
        return list;
    }
}

