/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.nio;

import ch.cyberduck.core.Path;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.Directory;
import ch.cyberduck.core.features.Write;
import ch.cyberduck.core.nio.LocalExceptionMappingService;
import ch.cyberduck.core.nio.LocalSession;
import ch.cyberduck.core.transfer.TransferStatus;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;

public class LocalDirectoryFeature
implements Directory<Void> {
    private final LocalSession session;

    public LocalDirectoryFeature(LocalSession session) {
        this.session = session;
    }

    public Path mkdir(Path folder, String region, TransferStatus status) throws BackgroundException {
        try {
            Files.createDirectory(this.session.toPath(folder), new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new LocalExceptionMappingService().map("Cannot create folder {0}", e, folder);
        }
        return folder;
    }

    public boolean isSupported(Path workdir, String name) {
        return true;
    }

    public Directory<Void> withWriter(Write<Void> writer) {
        return this;
    }
}

