/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.googledrive;

import ch.cyberduck.core.Cache;
import ch.cyberduck.core.DisabledListProgressListener;
import ch.cyberduck.core.ListProgressListener;
import ch.cyberduck.core.ListService;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.googledrive.AbstractDriveListService;
import ch.cyberduck.core.googledrive.DriveFileidProvider;
import ch.cyberduck.core.googledrive.DriveSession;

public class FileidDriveListService
extends AbstractDriveListService {
    private final DriveFileidProvider provider;
    private final Path file;

    public FileidDriveListService(DriveSession session, DriveFileidProvider provider, Path file) {
        super(session, 1);
        this.provider = provider;
        this.file = file;
    }

    @Override
    protected String query(Path directory, ListProgressListener listener) throws BackgroundException {
        return String.format("name = '%s' and '%s' in parents", this.file.getName(), this.provider.getFileid(directory, (ListProgressListener)new DisabledListProgressListener()));
    }

    @Override
    public ListService withCache(Cache<Path> cache) {
        this.provider.withCache((Cache)cache);
        return this;
    }
}

