/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.local;

import ch.cyberduck.binding.Proxy;
import ch.cyberduck.binding.application.NSOpenPanel;
import ch.cyberduck.binding.foundation.NSArray;
import ch.cyberduck.binding.foundation.NSData;
import ch.cyberduck.binding.foundation.NSEnumerator;
import ch.cyberduck.binding.foundation.NSObject;
import ch.cyberduck.binding.foundation.NSURL;
import ch.cyberduck.core.Local;
import ch.cyberduck.core.LocalFactory;
import ch.cyberduck.core.LocaleFactory;
import ch.cyberduck.core.exception.AccessDeniedException;
import ch.cyberduck.core.exception.LocalAccessDeniedException;
import ch.cyberduck.core.local.FilesystemBookmarkResolver;
import ch.cyberduck.core.preferences.Preferences;
import ch.cyberduck.core.preferences.PreferencesFactory;
import ch.cyberduck.core.threading.DefaultMainAction;
import java.text.MessageFormat;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.log4j.Logger;
import org.rococoa.ObjCObjectByReference;
import org.rococoa.cocoa.foundation.NSError;
import org.rococoa.cocoa.foundation.NSInteger;

public abstract class AbstractPromptBookmarkResolver
implements FilesystemBookmarkResolver<NSURL> {
    private static final Logger log = Logger.getLogger(AbstractPromptBookmarkResolver.class);
    private final Preferences preferences = PreferencesFactory.get();
    private final int create;
    private final int resolve;
    private final Proxy proxy = new Proxy();

    public AbstractPromptBookmarkResolver(int create, int resolve) {
        this.create = create;
        this.resolve = resolve;
    }

    public String create(Local file) throws AccessDeniedException {
        NSData data;
        ObjCObjectByReference error = new ObjCObjectByReference();
        NSURL url = NSURL.fileURLWithPath((String)file.getAbsolute());
        if (log.isTraceEnabled()) {
            log.trace((Object)String.format("Resolved file %s to url %s", file, url));
        }
        if (null == (data = url.bookmarkDataWithOptions_includingResourceValuesForKeys_relativeToURL_error(this.create, null, null, error))) {
            log.warn((Object)String.format("Failure getting bookmark data for file %s", file));
            NSError f = (NSError)error.getValueAs(NSError.class);
            if (null == f) {
                throw new LocalAccessDeniedException(file.getAbsolute());
            }
            throw new LocalAccessDeniedException(String.format("%s", f.localizedDescription()));
        }
        String encoded = data.base64Encoding();
        if (log.isTraceEnabled()) {
            log.trace((Object)String.format("Encoded bookmark for %s as %s", file, encoded));
        }
        return encoded;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public NSURL resolve(Local file, boolean interactive) throws AccessDeniedException {
        NSData bookmark;
        if (null == file.getBookmark()) {
            if (!interactive) throw new LocalAccessDeniedException(String.format("No security scoped bookmark for %s", file.getName()));
            String reference = this.choose(file);
            file.setBookmark(reference);
            bookmark = NSData.dataWithBase64EncodedString((String)reference);
        } else {
            bookmark = NSData.dataWithBase64EncodedString((String)file.getBookmark());
        }
        ObjCObjectByReference error = new ObjCObjectByReference();
        NSURL resolved = NSURL.URLByResolvingBookmarkData((NSData)bookmark, (int)this.resolve, (ObjCObjectByReference)error);
        if (null != resolved) return resolved;
        log.warn((Object)String.format("Error resolving bookmark for %s to URL", file));
        NSError f = (NSError)error.getValueAs(NSError.class);
        if (null != f) throw new LocalAccessDeniedException(String.format("%s", f.localizedDescription()));
        throw new LocalAccessDeniedException(file.getAbsolute());
    }

    public String choose(final Local file) throws AccessDeniedException {
        final AtomicReference selected = new AtomicReference();
        log.warn((Object)String.format("Prompt for file %s to obtain bookmark reference", file));
        DefaultMainAction action = new DefaultMainAction(){

            public void run() {
                NSOpenPanel panel = NSOpenPanel.openPanel();
                panel.setCanChooseDirectories(file.isDirectory());
                panel.setCanChooseFiles(file.isFile());
                panel.setAllowsMultipleSelection(false);
                panel.setMessage(MessageFormat.format(LocaleFactory.localizedString((String)"Select {0}", (String)"Credentials"), file.getAbbreviatedPath()));
                panel.setPrompt(LocaleFactory.localizedString((String)"Choose"));
                NSInteger modal = panel.runModal(file.getParent().getAbsolute(), file.getName());
                if (modal.intValue() == 1) {
                    NSObject next;
                    NSArray filenames = panel.filenames();
                    NSEnumerator enumerator = filenames.objectEnumerator();
                    while ((next = enumerator.nextObject()) != null) {
                        selected.set(LocalFactory.get((String)next.toString()));
                    }
                }
                panel.orderOut(null);
            }
        };
        this.proxy.invoke((Runnable)action, action.lock(), true);
        String reference = this.create((Local)selected.get());
        if (reference == null) {
            throw new LocalAccessDeniedException(String.format("Prompt for %s canceled", file));
        }
        return reference;
    }
}

