/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.spectra;

import ch.cyberduck.core.AbstractExceptionMappingService;
import ch.cyberduck.core.DefaultIOExceptionMappingService;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.exception.LoginFailureException;
import ch.cyberduck.core.http.HttpResponseExceptionMappingService;
import com.spectralogic.ds3client.networking.FailedRequestException;
import java.io.IOException;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.client.HttpResponseException;

public class SpectraExceptionMappingService
extends AbstractExceptionMappingService<FailedRequestException> {
    public BackgroundException map(FailedRequestException e) {
        StringBuilder buffer = new StringBuilder();
        if (null != e.getError()) {
            this.append(buffer, e.getError().getMessage());
        }
        switch (e.getStatusCode()) {
            case 403: {
                if (null == e.getError() || !StringUtils.isNotBlank((CharSequence)e.getError().getCode())) break;
                switch (e.getError().getCode()) {
                    case "SignatureDoesNotMatch": {
                        return new LoginFailureException(buffer.toString(), (Throwable)e);
                    }
                    case "InvalidAccessKeyId": {
                        return new LoginFailureException(buffer.toString(), (Throwable)e);
                    }
                    case "InvalidClientTokenId": {
                        return new LoginFailureException(buffer.toString(), (Throwable)e);
                    }
                    case "InvalidSecurity": {
                        return new LoginFailureException(buffer.toString(), (Throwable)e);
                    }
                    case "MissingClientTokenId": {
                        return new LoginFailureException(buffer.toString(), (Throwable)e);
                    }
                    case "MissingAuthenticationToken": {
                        return new LoginFailureException(buffer.toString(), (Throwable)e);
                    }
                }
            }
        }
        if (e.getCause() instanceof IOException) {
            return new DefaultIOExceptionMappingService().map((IOException)e.getCause());
        }
        return new HttpResponseExceptionMappingService().map(new HttpResponseException(e.getStatusCode(), buffer.toString()));
    }
}

