/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.sds;

import ch.cyberduck.core.Cache;
import ch.cyberduck.core.ConnectionCallback;
import ch.cyberduck.core.DefaultIOExceptionMappingService;
import ch.cyberduck.core.DisabledListProgressListener;
import ch.cyberduck.core.ListProgressListener;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathAttributes;
import ch.cyberduck.core.Session;
import ch.cyberduck.core.VersionId;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.AttributesFinder;
import ch.cyberduck.core.features.Find;
import ch.cyberduck.core.features.MultipartWrite;
import ch.cyberduck.core.features.Write;
import ch.cyberduck.core.http.HttpRange;
import ch.cyberduck.core.http.HttpResponseOutputStream;
import ch.cyberduck.core.io.ChecksumCompute;
import ch.cyberduck.core.io.DisabledChecksumCompute;
import ch.cyberduck.core.io.MemorySegementingOutputStream;
import ch.cyberduck.core.preferences.PreferencesFactory;
import ch.cyberduck.core.sds.SDSApiClient;
import ch.cyberduck.core.sds.SDSExceptionMappingService;
import ch.cyberduck.core.sds.SDSNodeIdProvider;
import ch.cyberduck.core.sds.SDSSession;
import ch.cyberduck.core.sds.SDSWriteFeature;
import ch.cyberduck.core.sds.io.swagger.client.ApiClient;
import ch.cyberduck.core.sds.io.swagger.client.ApiException;
import ch.cyberduck.core.sds.io.swagger.client.api.NodesApi;
import ch.cyberduck.core.sds.io.swagger.client.model.CompleteUploadRequest;
import ch.cyberduck.core.sds.io.swagger.client.model.CreateFileUploadRequest;
import ch.cyberduck.core.sds.io.swagger.client.model.CreateFileUploadResponse;
import ch.cyberduck.core.sds.io.swagger.client.model.FileKey;
import ch.cyberduck.core.sds.io.swagger.client.model.Node;
import ch.cyberduck.core.sds.triplecrypt.CryptoExceptionMappingService;
import ch.cyberduck.core.sds.triplecrypt.TripleCryptConverter;
import ch.cyberduck.core.shared.DefaultAttributesFinderFeature;
import ch.cyberduck.core.shared.DefaultFindFeature;
import ch.cyberduck.core.threading.BackgroundExceptionCallable;
import ch.cyberduck.core.threading.DefaultRetryCallable;
import ch.cyberduck.core.transfer.TransferStatus;
import com.dracoon.sdk.crypto.Crypto;
import com.dracoon.sdk.crypto.CryptoSystemException;
import com.dracoon.sdk.crypto.InvalidFileKeyException;
import com.dracoon.sdk.crypto.InvalidKeyPairException;
import com.dracoon.sdk.crypto.model.EncryptedFileKey;
import com.dracoon.sdk.crypto.model.PlainFileKey;
import com.dracoon.sdk.crypto.model.UserPublicKey;
import com.fasterxml.jackson.databind.ObjectReader;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.BufferedHttpEntity;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.entity.mime.content.ByteArrayBody;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.util.EntityUtils;
import org.apache.log4j.Logger;

public class SDSMultipartWriteFeature
implements MultipartWrite<VersionId> {
    private static final Logger log = Logger.getLogger(SDSMultipartWriteFeature.class);
    private final SDSSession session;
    private final SDSNodeIdProvider nodeid;
    private final Find finder;
    private final AttributesFinder attributes;

    public SDSMultipartWriteFeature(SDSSession session, SDSNodeIdProvider nodeid) {
        this(session, nodeid, (Find)new DefaultFindFeature((Session)session), (AttributesFinder)new DefaultAttributesFinderFeature((Session)session));
    }

    public SDSMultipartWriteFeature(SDSSession session, SDSNodeIdProvider nodeid, Find finder, AttributesFinder attributes) {
        this.session = session;
        this.nodeid = nodeid;
        this.finder = finder;
        this.attributes = attributes;
    }

    public HttpResponseOutputStream<VersionId> write(Path file, TransferStatus status, ConnectionCallback callback) throws BackgroundException {
        CreateFileUploadRequest body = new CreateFileUploadRequest();
        body.setParentId(Long.parseLong(this.nodeid.getFileid(file.getParent(), (ListProgressListener)new DisabledListProgressListener())));
        body.setName(file.getName());
        body.classification(SDSWriteFeature.DEFAULT_CLASSIFICATION);
        try {
            CreateFileUploadResponse response = new NodesApi((ApiClient)this.session.getClient()).createFileUpload(body, "");
            String id = response.getUploadId();
            final MultipartOutputStream proxy = new MultipartOutputStream(id, file, status);
            return new HttpResponseOutputStream<VersionId>((OutputStream)new MemorySegementingOutputStream((OutputStream)proxy, Integer.valueOf(PreferencesFactory.get().getInteger("sds.upload.multipart.chunksize")))){

                public VersionId getStatus() throws BackgroundException {
                    return proxy.getVersionId();
                }
            };
        }
        catch (ApiException e) {
            throw new SDSExceptionMappingService().map(e);
        }
    }

    public Write.Append append(Path file, Long length, Cache<Path> cache) throws BackgroundException {
        if (this.finder.withCache(cache).find(file)) {
            PathAttributes attributes = this.attributes.withCache(cache).find(file);
            return new Write.Append(false, true).withSize(Long.valueOf(attributes.getSize())).withChecksum(attributes.getChecksum());
        }
        return Write.notfound;
    }

    public boolean temporary() {
        return false;
    }

    public boolean random() {
        return false;
    }

    public ChecksumCompute checksum(Path file) {
        return new DisabledChecksumCompute();
    }

    private final class MultipartOutputStream
    extends OutputStream {
        private final String uploadId;
        private final Path file;
        private final TransferStatus overall;
        private final AtomicBoolean close = new AtomicBoolean();
        private Long offset = 0L;
        private VersionId versionId;

        public MultipartOutputStream(String uploadId, Path file, TransferStatus status) {
            this.uploadId = uploadId;
            this.file = file;
            this.overall = status;
        }

        @Override
        public void write(int value) throws IOException {
            throw new IOException(new UnsupportedOperationException());
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            try {
                final byte[] content = Arrays.copyOfRange(b, off, len);
                final HttpEntity entity = MultipartEntityBuilder.create().setBoundary("------------------------d8ad73fe428d737a").addPart("file", (ContentBody)new ByteArrayBody(content, this.file.getName())).build();
                new DefaultRetryCallable((BackgroundExceptionCallable)new BackgroundExceptionCallable<Void>(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    public Void call() throws BackgroundException {
                        SDSApiClient client = (SDSApiClient)SDSMultipartWriteFeature.this.session.getClient();
                        try {
                            HttpPost request = new HttpPost(String.format("%s/v4/nodes/files/uploads/%s", client.getBasePath(), MultipartOutputStream.this.uploadId));
                            request.setEntity(entity);
                            request.setHeader("X-Sds-Auth-Token", "");
                            request.setHeader("Content-Type", String.format("multipart/form-data; boundary=%s", "------------------------d8ad73fe428d737a"));
                            if (0L != MultipartOutputStream.this.overall.getLength() && 0 != content.length) {
                                HttpRange range = HttpRange.byLength((long)MultipartOutputStream.this.offset, (long)content.length);
                                String header = MultipartOutputStream.this.overall.getLength() == -1L ? String.format("%d-%d/*", range.getStart(), range.getEnd()) : String.format("%d-%d/%d", range.getStart(), range.getEnd(), MultipartOutputStream.this.overall.getOffset() + MultipartOutputStream.this.overall.getLength());
                                request.addHeader("Content-Range", String.format("bytes %s", header));
                            }
                            CloseableHttpResponse response = client.getClient().execute((HttpUriRequest)request);
                            try {
                                switch (response.getStatusLine().getStatusCode()) {
                                    case 201: {
                                        MultipartOutputStream.this.offset = MultipartOutputStream.this.offset + (long)content.length;
                                        return null;
                                    }
                                    default: {
                                        EntityUtils.updateEntity((HttpResponse)response, (HttpEntity)new BufferedHttpEntity(response.getEntity()));
                                        throw new SDSExceptionMappingService().map(new ApiException(response.getStatusLine().getStatusCode(), response.getStatusLine().getReasonPhrase(), Collections.emptyMap(), EntityUtils.toString((HttpEntity)response.getEntity())));
                                    }
                                }
                            }
                            finally {
                                EntityUtils.consume((HttpEntity)response.getEntity());
                            }
                        }
                        catch (IOException e) {
                            try {
                                if (log.isInfoEnabled()) {
                                    log.info((Object)String.format("Cancel failed upload %s for %s", MultipartOutputStream.this.uploadId, MultipartOutputStream.this.file));
                                }
                                new NodesApi((ApiClient)SDSMultipartWriteFeature.this.session.getClient()).cancelFileUpload("", MultipartOutputStream.this.uploadId);
                                throw new DefaultIOExceptionMappingService().map(e);
                            }
                            catch (ApiException f) {
                                throw new SDSExceptionMappingService().map(f);
                            }
                        }
                    }
                }, this.overall).call();
            }
            catch (BackgroundException e) {
                throw new IOException(e.getMessage(), e);
            }
        }

        @Override
        public void close() throws IOException {
            try {
                if (this.close.get()) {
                    log.warn((Object)String.format("Skip double close of stream %s", this));
                    return;
                }
                CompleteUploadRequest body = new CompleteUploadRequest();
                body.setResolutionStrategy(CompleteUploadRequest.ResolutionStrategyEnum.OVERWRITE);
                if (this.overall.getFilekey() != null) {
                    ObjectReader reader = ((SDSApiClient)SDSMultipartWriteFeature.this.session.getClient()).getJSON().getContext(null).readerFor(FileKey.class);
                    FileKey fileKey = (FileKey)reader.readValue(this.overall.getFilekey().array());
                    EncryptedFileKey encryptFileKey = Crypto.encryptFileKey((PlainFileKey)TripleCryptConverter.toCryptoPlainFileKey(fileKey), (UserPublicKey)TripleCryptConverter.toCryptoUserPublicKey(SDSMultipartWriteFeature.this.session.keyPair().getPublicKeyContainer()));
                    body.setFileKey(TripleCryptConverter.toSwaggerFileKey(encryptFileKey));
                }
                Node upload = new NodesApi((ApiClient)SDSMultipartWriteFeature.this.session.getClient()).completeFileUpload(this.uploadId, body, "", null);
                this.versionId = new VersionId(String.valueOf(upload.getId()));
            }
            catch (ApiException e) {
                throw new IOException(new SDSExceptionMappingService().map("Upload {0} failed", e, this.file));
            }
            catch (CryptoSystemException | InvalidFileKeyException | InvalidKeyPairException e) {
                throw new IOException(new CryptoExceptionMappingService().map("Upload {0} failed", e, this.file));
            }
            catch (BackgroundException e) {
                throw new IOException(e);
            }
            finally {
                this.close.set(true);
            }
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("MultipartOutputStream{");
            sb.append("id='").append(this.uploadId).append('\'');
            sb.append(", file=").append(this.file);
            sb.append('}');
            return sb.toString();
        }

        public VersionId getVersionId() {
            return this.versionId;
        }
    }
}

