/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core;

import ch.cyberduck.core.Credentials;
import ch.cyberduck.core.Host;
import ch.cyberduck.core.Local;
import ch.cyberduck.core.PasswordStore;
import ch.cyberduck.core.preferences.Preferences;
import ch.cyberduck.core.preferences.PreferencesFactory;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public abstract class HostPasswordStore
implements PasswordStore {
    private static final Logger log = Logger.getLogger(HostPasswordStore.class);
    private final Preferences preferences = PreferencesFactory.get();

    public String findLoginPassword(Host bookmark) {
        String password;
        if (StringUtils.isEmpty((CharSequence)bookmark.getHostname())) {
            log.warn((Object)"No hostname given");
            return null;
        }
        Credentials credentials = bookmark.getCredentials();
        if (StringUtils.isEmpty((CharSequence)credentials.getUsername())) {
            log.warn((Object)"No username given");
            return null;
        }
        if (log.isInfoEnabled()) {
            log.info((Object)String.format("Fetching login password from keychain for %s", bookmark));
        }
        if (null == (password = this.getPassword(bookmark.getProtocol().getScheme(), bookmark.getPort(), bookmark.getHostname(), credentials.getUsername())) && log.isInfoEnabled()) {
            log.info((Object)String.format("Password not found in keychain for %s", bookmark));
        }
        return password;
    }

    public String findLoginToken(Host bookmark) {
        String token;
        if (StringUtils.isEmpty((CharSequence)bookmark.getHostname())) {
            log.warn((Object)"No hostname given");
            return null;
        }
        Credentials credentials = bookmark.getCredentials();
        if (log.isInfoEnabled()) {
            log.info((Object)String.format("Fetching login token from keychain for %s", bookmark));
        }
        if (null == (token = this.getPassword(bookmark.getProtocol().getScheme(), bookmark.getPort(), bookmark.getHostname(), bookmark.getProtocol().getPasswordPlaceholder())) && log.isInfoEnabled()) {
            log.info((Object)String.format("Token not found in keychain for %s", bookmark));
        }
        return token;
    }

    public String findPrivateKeyPassphrase(Host bookmark) {
        if (StringUtils.isEmpty((CharSequence)bookmark.getHostname())) {
            log.warn((Object)"No hostname given");
            return null;
        }
        Credentials credentials = bookmark.getCredentials();
        if (StringUtils.isEmpty((CharSequence)credentials.getUsername())) {
            log.warn((Object)"No username given");
            return null;
        }
        if (log.isInfoEnabled()) {
            log.info((Object)String.format("Fetching private key passphrase from keychain for %s", bookmark));
        }
        if (credentials.isPublicKeyAuthentication()) {
            Local key = credentials.getIdentity();
            String passphrase = this.getPassword(bookmark.getHostname(), key.getAbbreviatedPath());
            if (null == passphrase) {
                passphrase = this.getPassword("SSH", key.getAbsolute());
            }
            if (null == passphrase) {
                passphrase = this.getPassword("SSHKeychain", key.getAbbreviatedPath());
            }
            if (null == passphrase && log.isInfoEnabled()) {
                log.info((Object)String.format("Passphrase not found in keychain for %s", key));
            }
            return passphrase;
        }
        return null;
    }

    public void save(Host bookmark) {
        if (StringUtils.isEmpty((CharSequence)bookmark.getHostname())) {
            log.warn((Object)"No hostname given");
            return;
        }
        Credentials credentials = bookmark.getCredentials();
        if (!credentials.isSaved()) {
            if (log.isInfoEnabled()) {
                log.info((Object)String.format("Skip writing credentials for bookmark %s", bookmark.getHostname()));
            }
            return;
        }
        if (credentials.isAnonymousLogin()) {
            if (log.isInfoEnabled()) {
                log.info((Object)String.format("Do not write anonymous credentials for bookmark %s", bookmark.getHostname()));
            }
            return;
        }
        if (log.isInfoEnabled()) {
            log.info((Object)String.format("Add password for bookmark %s", bookmark));
        }
        if (credentials.isPublicKeyAuthentication()) {
            this.addPassword(bookmark.getHostname(), credentials.getIdentity().getAbbreviatedPath(), credentials.getPassword());
        }
        if (credentials.isPasswordAuthentication()) {
            if (StringUtils.isEmpty((CharSequence)credentials.getUsername())) {
                log.warn((Object)String.format("No username in credentials for bookmark %s", bookmark.getHostname()));
                return;
            }
            this.addPassword(bookmark.getProtocol().getScheme(), bookmark.getPort(), bookmark.getHostname(), credentials.getUsername(), credentials.getPassword());
        }
        if (credentials.isTokenAuthentication()) {
            this.addPassword(bookmark.getProtocol().getScheme(), bookmark.getPort(), bookmark.getHostname(), bookmark.getProtocol().getPasswordPlaceholder(), credentials.getToken());
        }
    }
}

