/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.cryptolib.v1;

import java.nio.ByteBuffer;
import java.security.MessageDigest;
import java.security.SecureRandom;
import java.util.Arrays;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.Mac;
import javax.crypto.SecretKey;
import javax.crypto.ShortBufferException;
import javax.crypto.spec.IvParameterSpec;
import org.cryptomator.cryptolib.api.AuthenticationFailedException;
import org.cryptomator.cryptolib.api.FileHeader;
import org.cryptomator.cryptolib.api.FileHeaderCryptor;
import org.cryptomator.cryptolib.common.CipherSupplier;
import org.cryptomator.cryptolib.common.MacSupplier;
import org.cryptomator.cryptolib.v1.FileHeaderImpl;

class FileHeaderCryptorImpl
implements FileHeaderCryptor {
    private final SecretKey headerKey;
    private final SecretKey macKey;
    private final SecureRandom random;

    FileHeaderCryptorImpl(SecretKey headerKey, SecretKey macKey, SecureRandom random) {
        this.headerKey = headerKey;
        this.macKey = macKey;
        this.random = random;
    }

    @Override
    public FileHeader create() {
        byte[] nonce = new byte[16];
        this.random.nextBytes(nonce);
        byte[] contentKey = new byte[32];
        this.random.nextBytes(contentKey);
        return new FileHeaderImpl(nonce, contentKey);
    }

    @Override
    public int headerSize() {
        return 88;
    }

    @Override
    public ByteBuffer encryptHeader(FileHeader header) {
        FileHeaderImpl headerImpl = FileHeaderImpl.cast(header);
        ByteBuffer payloadCleartextBuf = ByteBuffer.allocate(40);
        payloadCleartextBuf.putLong(-1L);
        payloadCleartextBuf.put(headerImpl.getPayload().getContentKeyBytes());
        payloadCleartextBuf.flip();
        try {
            ByteBuffer result = ByteBuffer.allocate(88);
            result.put(headerImpl.getNonce());
            Cipher cipher = CipherSupplier.AES_CTR.forEncryption(this.headerKey, new IvParameterSpec(headerImpl.getNonce()));
            int encrypted = cipher.doFinal(payloadCleartextBuf, result);
            assert (encrypted == 40);
            ByteBuffer nonceAndCiphertextBuf = result.duplicate();
            nonceAndCiphertextBuf.flip();
            Mac mac = MacSupplier.HMAC_SHA256.withKey(this.macKey);
            mac.update(nonceAndCiphertextBuf);
            result.put(mac.doFinal());
            result.flip();
            ByteBuffer byteBuffer = result;
            return byteBuffer;
        }
        catch (ShortBufferException e) {
            throw new IllegalStateException("Result buffer too small for encrypted header payload.", e);
        }
        catch (BadPaddingException | IllegalBlockSizeException e) {
            throw new IllegalStateException("Unexpected exception for CTR ciphers.", e);
        }
        finally {
            Arrays.fill(payloadCleartextBuf.array(), (byte)0);
        }
    }

    @Override
    public FileHeader decryptHeader(ByteBuffer ciphertextHeaderBuf) throws AuthenticationFailedException {
        if (ciphertextHeaderBuf.remaining() < 88) {
            throw new IllegalArgumentException("Malformed ciphertext header");
        }
        ByteBuffer buf = ciphertextHeaderBuf.asReadOnlyBuffer();
        byte[] nonce = new byte[16];
        buf.position(0);
        buf.get(nonce);
        byte[] ciphertextPayload = new byte[40];
        buf.position(16);
        buf.get(ciphertextPayload);
        byte[] expectedMac = new byte[32];
        buf.position(56);
        buf.get(expectedMac);
        ByteBuffer nonceAndCiphertextBuf = buf.duplicate();
        nonceAndCiphertextBuf.position(0).limit(56);
        Mac mac = MacSupplier.HMAC_SHA256.withKey(this.macKey);
        mac.update(nonceAndCiphertextBuf);
        byte[] calculatedMac = mac.doFinal();
        if (!MessageDigest.isEqual(expectedMac, calculatedMac)) {
            throw new AuthenticationFailedException("Header MAC doesn't match.");
        }
        ByteBuffer payloadCleartextBuf = ByteBuffer.allocate(40);
        try {
            Cipher cipher = CipherSupplier.AES_CTR.forDecryption(this.headerKey, new IvParameterSpec(nonce));
            int decrypted = cipher.doFinal(ByteBuffer.wrap(ciphertextPayload), payloadCleartextBuf);
            assert (decrypted == 40);
            payloadCleartextBuf.position(0);
            long fileSize = payloadCleartextBuf.getLong();
            payloadCleartextBuf.position(8);
            byte[] contentKey = new byte[32];
            payloadCleartextBuf.get(contentKey);
            FileHeaderImpl header = new FileHeaderImpl(nonce, contentKey);
            header.setFilesize(fileSize);
            FileHeaderImpl fileHeaderImpl = header;
            return fileHeaderImpl;
        }
        catch (ShortBufferException e) {
            throw new IllegalStateException("Result buffer too small for decrypted header payload.", e);
        }
        catch (BadPaddingException | IllegalBlockSizeException e) {
            throw new IllegalStateException("Unexpected exception for CTR ciphers.", e);
        }
        finally {
            Arrays.fill(payloadCleartextBuf.array(), (byte)0);
        }
    }
}

