/*
 * Decompiled with CFR 0.152.
 */
package com.joyent.manta.config;

import com.joyent.http.signature.KeyFingerprinter;
import com.joyent.http.signature.KeyPairLoader;
import com.joyent.manta.config.ConfigContext;
import com.joyent.manta.exception.ConfigurationException;
import java.io.File;
import java.io.IOException;
import java.security.KeyPair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KeyPairFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(KeyPairFactory.class);
    private final ConfigContext config;

    public KeyPairFactory(ConfigContext config) {
        this.config = config;
    }

    public KeyPair createKeyPair() {
        KeyPair keyPair;
        block5: {
            String privateKeyContent = this.config.getPrivateKeyContent();
            String keyPath = this.config.getMantaKeyPath();
            String password = this.config.getPassword();
            char[] charPassword = password != null ? password.toCharArray() : null;
            try {
                if (privateKeyContent != null) {
                    keyPair = KeyPairLoader.getKeyPair((String)privateKeyContent, (char[])charPassword);
                    break block5;
                }
                if (keyPath != null) {
                    keyPair = KeyPairLoader.getKeyPair((File)new File(keyPath), (char[])charPassword);
                    break block5;
                }
                String msg = "Private key content setting must be set if key file path is not set";
                ConfigurationException exception = new ConfigurationException(msg);
                exception.setContextValue("config", this.config);
                throw exception;
            }
            catch (IOException e) {
                String msg = String.format("Unable to read key files from path: %s", keyPath);
                throw new ConfigurationException(msg, e);
            }
        }
        if (!KeyFingerprinter.verifyFingerprint((KeyPair)keyPair, (String)this.config.getMantaKeyId())) {
            String msg = String.format("Given fingerprint %s does not match expected key MD5:%s SHA256:%s", this.config.getMantaKeyId(), KeyFingerprinter.md5Fingerprint((KeyPair)keyPair), KeyFingerprinter.sha256Fingerprint((KeyPair)keyPair));
            ConfigurationException exception = new ConfigurationException(msg);
            throw exception;
        }
        return keyPair;
    }
}

