/*
 * Decompiled with CFR 0.152.
 */
package com.joyent.manta.client;

import com.joyent.manta.client.MantaMBeanable;
import java.lang.management.ManagementFactory;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import javax.management.DynamicMBean;
import javax.management.JMException;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class MantaMBeanSupervisor
implements AutoCloseable {
    private static final Logger LOGGER = LoggerFactory.getLogger(MantaMBeanSupervisor.class);
    private static final String FMT_MBEAN_OBJECT_NAME = "com.joyent.manta.client:type=%s[%d]";
    private static final AtomicInteger SUPERVISOR_COUNT = new AtomicInteger(0);
    private final Map<ObjectName, DynamicMBean> beans;
    private final int idx;
    private final AtomicBoolean closed = new AtomicBoolean(false);

    MantaMBeanSupervisor() {
        this.idx = SUPERVISOR_COUNT.incrementAndGet();
        this.beans = new HashMap<ObjectName, DynamicMBean>(2);
    }

    void expose(MantaMBeanable beanable) {
        ObjectName name;
        if (this.closed.get()) {
            throw new IllegalStateException("Cannot register MBeans, supervisor has been closed");
        }
        DynamicMBean bean = beanable.toMBean();
        if (bean == null) {
            if (LOGGER.isWarnEnabled()) {
                LOGGER.warn("MantaMBeanable object returned null");
            }
            return;
        }
        try {
            name = new ObjectName(String.format(FMT_MBEAN_OBJECT_NAME, bean.getClass().getSimpleName(), this.idx));
        }
        catch (JMException e) {
            LOGGER.warn("Error creating bean: " + bean.getClass().getSimpleName(), (Throwable)e);
            return;
        }
        try {
            ManagementFactory.getPlatformMBeanServer().registerMBean(bean, name);
            this.beans.put(name, bean);
        }
        catch (JMException e) {
            LOGGER.warn(String.format("Error registering [%s] MBean in JMX", name), (Throwable)e);
        }
    }

    void reset() throws Exception {
        if (!this.beans.isEmpty()) {
            this.close();
        }
        this.closed.set(false);
    }

    Map<ObjectName, DynamicMBean> getBeans() {
        return Collections.unmodifiableMap(this.beans);
    }

    @Override
    public void close() throws Exception {
        if (this.closed.get()) {
            return;
        }
        this.closed.set(true);
        MBeanServer server = ManagementFactory.getPlatformMBeanServer();
        for (Map.Entry<ObjectName, DynamicMBean> bean : this.beans.entrySet()) {
            try {
                server.unregisterMBean(bean.getKey());
            }
            catch (JMException e) {
                LOGGER.warn(String.format("Error deregistering [%s] MBean in JMX", bean.getKey()), (Throwable)e);
            }
        }
        this.beans.clear();
    }
}

