/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.cli;

import ch.cyberduck.cli.TerminalBrowserLauncher;
import ch.cyberduck.cli.TerminalPreferences;
import ch.cyberduck.core.UnsecureHostPasswordStore;
import ch.cyberduck.core.editor.DefaultEditorFactory;
import ch.cyberduck.core.i18n.RegexLocale;
import ch.cyberduck.core.local.DefaultSymlinkFeature;
import ch.cyberduck.core.local.DesktopBrowserLauncher;
import ch.cyberduck.core.local.ExecApplicationLauncher;
import ch.cyberduck.core.preferences.MemoryPreferences;
import ch.cyberduck.core.preferences.StaticApplicationResourcesFinder;
import ch.cyberduck.core.preferences.UserHomeSupportDirectoryFinder;
import ch.cyberduck.core.proxy.EnvironmentVariableProxyFinder;
import java.awt.Desktop;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public class LinuxTerminalPreferences
extends TerminalPreferences {
    private static final Logger log = Logger.getLogger(LinuxTerminalPreferences.class);

    public LinuxTerminalPreferences() {
        super(new MemoryPreferences());
    }

    @Override
    protected void setDefaults() {
        super.setDefaults();
        try {
            Process echo = Runtime.getRuntime().exec(new String[]{"/bin/sh", "-c", "echo ~"});
            this.setDefault("local.user.home", StringUtils.strip((String)IOUtils.toString((InputStream)echo.getInputStream(), (Charset)Charset.defaultCharset())));
        }
        catch (IOException e) {
            log.warn((Object)"Failure determining user home with `echo ~`");
        }
        this.setDefault("ssh.authentication.agent.enable", String.valueOf(false));
        this.setDefault("bookmarks.folder.name", "bookmarks");
        this.setDefault("profiles.folder.name", "profiles");
        this.setDefault("connection.ssl.securerandom.algorithm", "NativePRNGNonBlocking");
    }

    @Override
    protected void setFactories() {
        super.setFactories();
        if (Desktop.isDesktopSupported()) {
            this.setDefault("factory.browserlauncher.class", DesktopBrowserLauncher.class.getName());
        } else {
            this.setDefault("factory.browserlauncher.class", TerminalBrowserLauncher.class.getName());
        }
        this.setDefault("factory.supportdirectoryfinder.class", UserHomeSupportDirectoryFinder.class.getName());
        this.setDefault("factory.applicationresourcesfinder.class", StaticApplicationResourcesFinder.class.getName());
        this.setDefault("factory.locale.class", RegexLocale.class.getName());
        this.setDefault("factory.applicationlauncher.class", ExecApplicationLauncher.class.getName());
        this.setDefault("factory.editorfactory.class", DefaultEditorFactory.class.getName());
        this.setDefault("factory.proxy.class", EnvironmentVariableProxyFinder.class.getName());
        this.setDefault("factory.symlink.class", DefaultSymlinkFeature.class.getName());
        this.setDefault("factory.passwordstore.class", UnsecureHostPasswordStore.class.getName());
    }
}

