/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.threading;

import ch.cyberduck.core.Controller;
import ch.cyberduck.core.ProgressListener;
import ch.cyberduck.core.TransferCollection;
import ch.cyberduck.core.pool.SessionPool;
import ch.cyberduck.core.preferences.PreferencesFactory;
import ch.cyberduck.core.threading.TransferBackgroundAction;
import ch.cyberduck.core.transfer.Transfer;
import ch.cyberduck.core.transfer.TransferListener;
import ch.cyberduck.core.transfer.TransferOptions;
import org.apache.log4j.Logger;

public class TransferCollectionBackgroundAction
extends TransferBackgroundAction {
    private static final Logger log = Logger.getLogger(TransferCollectionBackgroundAction.class);
    private final SessionPool source;
    private final SessionPool destination;
    private final Transfer transfer;

    public TransferCollectionBackgroundAction(Controller controller, SessionPool source, SessionPool destination, TransferListener transferListener, ProgressListener listener, Transfer transfer, TransferOptions options) {
        super(controller, source, destination, transferListener, listener, transfer, options);
        this.source = source;
        this.destination = destination;
        this.transfer = transfer;
    }

    @Override
    public void prepare() {
        super.prepare();
    }

    @Override
    public void cancel() {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Cancel background action for transfer %s", this.transfer));
        }
        super.cancel();
    }

    @Override
    public void finish() {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Finish background action for transfer %s", this.transfer));
        }
        super.finish();
        this.source.shutdown();
        this.destination.shutdown();
    }

    @Override
    public void cleanup() {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Cleanup background action for transfer %s", this.transfer));
        }
        super.cleanup();
        TransferCollection collection = TransferCollection.defaultCollection();
        if (PreferencesFactory.get().getBoolean("queue.removeItemWhenComplete") && this.transfer.isReset() && this.transfer.isComplete()) {
            collection.remove(this.transfer);
        } else {
            collection.collectionItemChanged(this.transfer);
        }
    }
}

