/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core;

import ch.cyberduck.core.Cache;
import ch.cyberduck.core.Credentials;
import ch.cyberduck.core.Host;
import ch.cyberduck.core.HostPasswordStore;
import ch.cyberduck.core.LocaleFactory;
import ch.cyberduck.core.LoginCallback;
import ch.cyberduck.core.LoginOptions;
import ch.cyberduck.core.LoginService;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.ProgressListener;
import ch.cyberduck.core.Session;
import ch.cyberduck.core.StringAppender;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.exception.LoginCanceledException;
import ch.cyberduck.core.exception.LoginFailureException;
import ch.cyberduck.core.preferences.Preferences;
import ch.cyberduck.core.preferences.PreferencesFactory;
import ch.cyberduck.core.proxy.Proxy;
import ch.cyberduck.core.threading.CancelCallback;
import java.text.MessageFormat;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public class KeychainLoginService
implements LoginService {
    private static final Logger log = Logger.getLogger(KeychainLoginService.class);
    private final Preferences preferences = PreferencesFactory.get();
    private final LoginCallback callback;
    private final HostPasswordStore keychain;

    public KeychainLoginService(LoginCallback prompt, HostPasswordStore keychain) {
        this.callback = prompt;
        this.keychain = keychain;
    }

    @Override
    public void validate(Host bookmark, String message, LoginOptions options) throws LoginCanceledException {
        String password;
        Credentials credentials;
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Validate login credentials for %s", bookmark));
        }
        if ((credentials = bookmark.getCredentials()).isPublicKeyAuthentication() && !credentials.getIdentity().attributes().getPermission().isReadable()) {
            log.warn((Object)String.format("Prompt to select identity file not readable %s", credentials.getIdentity()));
            credentials.setIdentity(this.callback.select(credentials.getIdentity()));
        }
        if (StringUtils.isBlank((CharSequence)(password = credentials.getPassword())) && options.keychain && StringUtils.isNotBlank((CharSequence)(password = this.keychain.findLoginPassword(bookmark)))) {
            if (log.isInfoEnabled()) {
                log.info((Object)String.format("Fetched password from keychain for %s", bookmark));
            }
            credentials.setSaved(false);
        }
        credentials.setPassword(password);
        if (!credentials.validate(bookmark.getProtocol(), options)) {
            if (StringUtils.isNotBlank((CharSequence)credentials.getUsername())) {
                if (StringUtils.isBlank((CharSequence)credentials.getPassword())) {
                    StringAppender appender = new StringAppender();
                    appender.append(message);
                    appender.append(LocaleFactory.localizedString("No login credentials could be found in the Keychain", "Credentials"));
                    bookmark.setCredentials(this.callback.prompt(bookmark, credentials.getUsername(), String.format("%s %s", LocaleFactory.localizedString("Login", "Login"), bookmark.getHostname()), appender.toString(), options));
                }
            } else {
                log.warn((Object)String.format("Prompt for username to connect to %s", bookmark));
                StringAppender appender = new StringAppender();
                appender.append(message);
                appender.append(LocaleFactory.localizedString("No login credentials could be found in the Keychain", "Credentials"));
                bookmark.setCredentials(this.callback.prompt(bookmark, credentials.getUsername(), String.format("%s %s", LocaleFactory.localizedString("Login", "Login"), bookmark.getHostname()), appender.toString(), options));
            }
        }
    }

    @Override
    public void authenticate(Proxy proxy, Session session, Cache<Path> cache, ProgressListener listener, CancelCallback cancel) throws BackgroundException {
        Host bookmark = session.getHost();
        if (session.alert(this.callback)) {
            this.callback.warn(bookmark, MessageFormat.format(LocaleFactory.localizedString("Unsecured {0} connection", "Credentials"), bookmark.getProtocol().getName()), MessageFormat.format("{0} {1}.", MessageFormat.format(LocaleFactory.localizedString("{0} will be sent in plaintext.", "Credentials"), bookmark.getProtocol().getPasswordPlaceholder()), LocaleFactory.localizedString("Please contact your web hosting service provider for assistance", "Support")), LocaleFactory.localizedString("Continue", "Credentials"), LocaleFactory.localizedString("Disconnect", "Credentials"), String.format("connection.unsecure.%s", bookmark.getHostname()));
        }
        listener.message(MessageFormat.format(LocaleFactory.localizedString("Authenticating as {0}", "Status"), StringUtils.isEmpty((CharSequence)bookmark.getCredentials().getUsername()) ? LocaleFactory.localizedString("Unknown") : bookmark.getCredentials().getUsername()));
        try {
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("Attempt authentication for %s", bookmark));
            }
            session.login(proxy, this.keychain, this.callback, cancel);
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("Login successful for session %s", session));
            }
            listener.message(LocaleFactory.localizedString("Login successful", "Credentials"));
            this.keychain.save(bookmark);
            bookmark.getCredentials().setPassed(true);
            bookmark.getCredentials().setPassword(null);
        }
        catch (LoginFailureException e) {
            listener.message(LocaleFactory.localizedString("Login failed", "Credentials"));
            bookmark.setCredentials(this.callback.prompt(bookmark, bookmark.getCredentials().getUsername(), LocaleFactory.localizedString("Login failed", "Credentials"), e.getDetail(), new LoginOptions(bookmark.getProtocol())));
            throw e;
        }
    }
}

