/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core;

import ch.cyberduck.core.AbstractPath;
import ch.cyberduck.core.CacheReference;
import ch.cyberduck.core.Path;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

public final class CaseInsensitivePathPredicate
implements CacheReference<Path> {
    private final AbstractPath.Type type;
    private final String path;

    public CaseInsensitivePathPredicate(Path file) {
        this.type = file.isSymbolicLink() ? AbstractPath.Type.symboliclink : (file.isFile() ? AbstractPath.Type.file : AbstractPath.Type.directory);
        this.path = StringUtils.lowerCase((String)file.getAbsolute());
    }

    public boolean equals(Object o) {
        if (null == o) {
            return false;
        }
        if (o instanceof CacheReference) {
            return this.hashCode() == o.hashCode();
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.type, this.path});
    }

    @Override
    public boolean test(Path test) {
        return this.hashCode() == new CaseInsensitivePathPredicate(test).hashCode();
    }
}

