/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.azure;

import ch.cyberduck.core.AbstractPath;
import ch.cyberduck.core.ConnectionCallback;
import ch.cyberduck.core.DisabledConnectionCallback;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathAttributes;
import ch.cyberduck.core.PathContainerService;
import ch.cyberduck.core.azure.AzureExceptionMappingService;
import ch.cyberduck.core.azure.AzurePathContainerService;
import ch.cyberduck.core.azure.AzureSession;
import ch.cyberduck.core.azure.AzureWriteFeature;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.exception.NotfoundException;
import ch.cyberduck.core.features.Directory;
import ch.cyberduck.core.features.Write;
import ch.cyberduck.core.io.Checksum;
import ch.cyberduck.core.io.DefaultStreamCloser;
import ch.cyberduck.core.transfer.TransferStatus;
import com.microsoft.azure.storage.OperationContext;
import com.microsoft.azure.storage.StorageException;
import com.microsoft.azure.storage.blob.BlobRequestOptions;
import com.microsoft.azure.storage.blob.CloudBlobClient;
import com.microsoft.azure.storage.blob.CloudBlobContainer;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URISyntaxException;
import java.util.EnumSet;
import org.apache.commons.io.input.NullInputStream;
import org.apache.commons.lang3.StringUtils;

public class AzureDirectoryFeature
implements Directory<Void> {
    private final PathContainerService containerService = new AzurePathContainerService();
    private final AzureSession session;
    private final OperationContext context;
    private Write<Void> writer;

    public AzureDirectoryFeature(AzureSession session, OperationContext context) {
        this.session = session;
        this.context = context;
        this.writer = new AzureWriteFeature(session, context);
    }

    public Path mkdir(Path folder, String region, TransferStatus status) throws BackgroundException {
        try {
            BlobRequestOptions options = new BlobRequestOptions();
            if (!this.containerService.isContainer(folder)) {
                if (Checksum.NONE == status.getChecksum()) {
                    status.setChecksum(this.writer.checksum(folder).compute((InputStream)new NullInputStream(0L), status));
                }
                EnumSet<AbstractPath.Type> type = EnumSet.copyOf(folder.getType());
                type.add(AbstractPath.Type.placeholder);
                Path placeholder = new Path(folder.getParent(), folder.getName(), type, new PathAttributes(folder.attributes()));
                new DefaultStreamCloser().close((OutputStream)this.writer.write(placeholder, status, (ConnectionCallback)new DisabledConnectionCallback()));
                return placeholder;
            }
            CloudBlobContainer container = ((CloudBlobClient)this.session.getClient()).getContainerReference(this.containerService.getContainer(folder).getName());
            container.create(options, this.context);
        }
        catch (URISyntaxException e) {
            throw new NotfoundException(e.getMessage(), (Throwable)e);
        }
        catch (StorageException e) {
            throw new AzureExceptionMappingService().map("Cannot create folder {0}", e, folder);
        }
        return folder;
    }

    public boolean isSupported(Path workdir, String name) {
        if (workdir.isRoot()) {
            if (StringUtils.length((CharSequence)name) > 63) {
                return false;
            }
            if (StringUtils.length((CharSequence)name) < 3) {
                return false;
            }
            return StringUtils.isAlphanumeric((CharSequence)StringUtils.removeAll((String)name, (String)"-"));
        }
        return true;
    }

    public Directory<Void> withWriter(Write<Void> writer) {
        this.writer = writer;
        return this;
    }
}

