/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.oauth;

import ch.cyberduck.core.AlphanumericRandomStringService;
import ch.cyberduck.core.Credentials;
import ch.cyberduck.core.DefaultIOExceptionMappingService;
import ch.cyberduck.core.Host;
import ch.cyberduck.core.HostPasswordStore;
import ch.cyberduck.core.LocaleFactory;
import ch.cyberduck.core.LoginCallback;
import ch.cyberduck.core.LoginOptions;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.exception.LoginCanceledException;
import ch.cyberduck.core.exception.LoginFailureException;
import ch.cyberduck.core.http.HttpResponseExceptionMappingService;
import ch.cyberduck.core.local.BrowserLauncher;
import ch.cyberduck.core.local.BrowserLauncherFactory;
import ch.cyberduck.core.oauth.OAuth2TokenListener;
import ch.cyberduck.core.oauth.OAuth2TokenListenerRegistry;
import ch.cyberduck.core.oauth.OAuthExceptionMappingService;
import ch.cyberduck.core.preferences.Preferences;
import ch.cyberduck.core.preferences.PreferencesFactory;
import ch.cyberduck.core.threading.CancelCallback;
import com.google.api.client.auth.oauth2.AuthorizationCodeFlow;
import com.google.api.client.auth.oauth2.AuthorizationCodeRequestUrl;
import com.google.api.client.auth.oauth2.BearerToken;
import com.google.api.client.auth.oauth2.ClientParametersAuthentication;
import com.google.api.client.auth.oauth2.Credential;
import com.google.api.client.auth.oauth2.RefreshTokenRequest;
import com.google.api.client.auth.oauth2.TokenResponse;
import com.google.api.client.auth.oauth2.TokenResponseException;
import com.google.api.client.http.GenericUrl;
import com.google.api.client.http.HttpExecuteInterceptor;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.http.apache.ApacheHttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.gson.GsonFactory;
import java.io.IOException;
import java.net.URI;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.client.HttpClient;
import org.apache.http.client.HttpResponseException;
import org.apache.log4j.Logger;

public class OAuth2AuthorizationService {
    private static final Logger log = Logger.getLogger(OAuth2AuthorizationService.class);
    private static final String OOB_REDIRECT_URI = "urn:ietf:wg:oauth:2.0:oob";
    private static final String CYBERDUCK_REDIRECT_URI = "x-cyberduck-action:oauth";
    private final Preferences preferences = PreferencesFactory.get();
    private final JsonFactory json = new GsonFactory();
    private final String tokenServerUrl;
    private final String authorizationServerUrl;
    private final String clientid;
    private final String clientsecret;
    public final BrowserLauncher browser = BrowserLauncherFactory.get();
    private final List<String> scopes;
    private final Map<String, String> additionalParameters = new HashMap<String, String>();
    private Credential.AccessMethod method = BearerToken.authorizationHeaderAccessMethod();
    private String redirectUri = "urn:ietf:wg:oauth:2.0:oob";
    private final HttpTransport transport;

    public OAuth2AuthorizationService(HttpClient client, String tokenServerUrl, String authorizationServerUrl, String clientid, String clientsecret, List<String> scopes) {
        this((HttpTransport)new ApacheHttpTransport(client), tokenServerUrl, authorizationServerUrl, clientid, clientsecret, scopes);
    }

    public OAuth2AuthorizationService(HttpTransport transport, String tokenServerUrl, String authorizationServerUrl, String clientid, String clientsecret, List<String> scopes) {
        this.transport = transport;
        this.tokenServerUrl = tokenServerUrl;
        this.authorizationServerUrl = authorizationServerUrl;
        this.clientid = clientid;
        this.clientsecret = clientsecret;
        this.scopes = scopes;
    }

    public Tokens authorize(Host bookmark, HostPasswordStore keychain, LoginCallback prompt, CancelCallback cancel) throws BackgroundException {
        Tokens saved = this.find(keychain, bookmark);
        if (saved.validate()) {
            if (saved.isExpired()) {
                try {
                    return this.refresh(saved);
                }
                catch (LoginFailureException e) {
                    log.warn((Object)String.format("Failure refreshing tokens from %s for %s", saved, bookmark));
                }
            } else {
                return saved;
            }
        }
        AuthorizationCodeFlow flow = new AuthorizationCodeFlow.Builder(this.method, this.transport, this.json, new GenericUrl(this.tokenServerUrl), (HttpExecuteInterceptor)new ClientParametersAuthentication(this.clientid, this.clientsecret), this.clientid, this.authorizationServerUrl).setScopes(this.scopes).build();
        AuthorizationCodeRequestUrl authorizationCodeRequestUrl = flow.newAuthorizationUrl();
        authorizationCodeRequestUrl.setRedirectUri(this.redirectUri);
        authorizationCodeRequestUrl.setState(new AlphanumericRandomStringService().random());
        for (Map.Entry<String, String> values : this.additionalParameters.entrySet()) {
            authorizationCodeRequestUrl.set(values.getKey(), (Object)values.getValue());
        }
        String url = authorizationCodeRequestUrl.build();
        if (!this.browser.open(url)) {
            log.warn((Object)String.format("Failed to launch web browser for %s", url));
        }
        if (StringUtils.equals((CharSequence)CYBERDUCK_REDIRECT_URI, (CharSequence)this.redirectUri)) {
            OAuth2TokenListenerRegistry registry = OAuth2TokenListenerRegistry.get();
            registry.register(new OAuth2TokenListener(){

                @Override
                public void callback(String param) {
                    log.warn((Object)String.format("Callback with code %s from redirect uri not currently handled.", param));
                }
            }, cancel);
        }
        Credentials credentials = prompt.prompt(bookmark, bookmark.getCredentials().getUsername(), LocaleFactory.localizedString((String)"OAuth2 Authentication", (String)"Credentials"), LocaleFactory.localizedString((String)"Paste the authentication code from your web browser", (String)"Credentials"), new LoginOptions(bookmark.getProtocol()).keychain(true).user(false).password(true).passwordPlaceholder(LocaleFactory.localizedString((String)"Authentication Code", (String)"Credentials")));
        try {
            if (StringUtils.isBlank((CharSequence)credentials.getPassword())) {
                throw new LoginCanceledException();
            }
            TokenResponse response = flow.newTokenRequest(credentials.getPassword()).setRedirectUri(this.redirectUri).setScopes(this.scopes.isEmpty() ? null : this.scopes).execute();
            Tokens tokens = new Tokens(response.getAccessToken(), response.getRefreshToken(), null == response.getExpiresInSeconds() ? System.currentTimeMillis() : System.currentTimeMillis() + response.getExpiresInSeconds() * 1000L);
            if (credentials.isSaved()) {
                this.save(keychain, bookmark, tokens);
            }
            return tokens;
        }
        catch (TokenResponseException e) {
            throw new OAuthExceptionMappingService().map(e);
        }
        catch (com.google.api.client.http.HttpResponseException e) {
            throw new HttpResponseExceptionMappingService().map(new HttpResponseException(e.getStatusCode(), e.getStatusMessage()));
        }
        catch (IOException e) {
            throw new DefaultIOExceptionMappingService().map(e);
        }
    }

    public Tokens refresh(Tokens tokens) throws BackgroundException {
        if (StringUtils.isBlank((CharSequence)tokens.getRefreshToken())) {
            log.warn((Object)"Missing refresh token");
            return tokens;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Refresh expired tokens %s", tokens));
        }
        try {
            TokenResponse response = new RefreshTokenRequest(this.transport, this.json, new GenericUrl(this.tokenServerUrl), tokens.getRefreshToken()).setClientAuthentication((HttpExecuteInterceptor)new ClientParametersAuthentication(this.clientid, this.clientsecret)).execute();
            long expiryInMilliseconds = System.currentTimeMillis() + response.getExpiresInSeconds() * 1000L;
            if (StringUtils.isBlank((CharSequence)response.getRefreshToken())) {
                return new Tokens(response.getAccessToken(), tokens.getRefreshToken(), expiryInMilliseconds);
            }
            return new Tokens(response.getAccessToken(), response.getRefreshToken(), expiryInMilliseconds);
        }
        catch (TokenResponseException e) {
            throw new OAuthExceptionMappingService().map(e);
        }
        catch (com.google.api.client.http.HttpResponseException e) {
            throw new HttpResponseExceptionMappingService().map(new HttpResponseException(e.getStatusCode(), e.getStatusMessage()));
        }
        catch (IOException e) {
            throw new DefaultIOExceptionMappingService().map(e);
        }
    }

    public Tokens find(HostPasswordStore keychain, Host bookmark) {
        long expiry = this.preferences.getLong(String.format("%s.oauth.expiry", bookmark.getProtocol().getIdentifier()));
        String prefix = this.getPrefix(bookmark);
        return new Tokens(keychain.getPassword(bookmark.getProtocol().getScheme(), bookmark.getPort(), URI.create(this.tokenServerUrl).getHost(), String.format("%s OAuth2 Access Token", prefix)), keychain.getPassword(bookmark.getProtocol().getScheme(), bookmark.getPort(), URI.create(this.tokenServerUrl).getHost(), String.format("%s OAuth2 Refresh Token", prefix)), expiry);
    }

    private void save(HostPasswordStore keychain, Host bookmark, Tokens tokens) {
        String prefix = this.getPrefix(bookmark);
        if (StringUtils.isNotBlank((CharSequence)tokens.getAccessToken())) {
            keychain.addPassword(bookmark.getProtocol().getScheme(), bookmark.getPort(), URI.create(this.tokenServerUrl).getHost(), String.format("%s OAuth2 Access Token", prefix), tokens.getAccessToken());
        }
        if (StringUtils.isNotBlank((CharSequence)tokens.refreshToken)) {
            keychain.addPassword(bookmark.getProtocol().getScheme(), bookmark.getPort(), URI.create(this.tokenServerUrl).getHost(), String.format("%s OAuth2 Refresh Token", prefix), tokens.getRefreshToken());
        }
        if (tokens.expiryInMilliseconds != null) {
            this.preferences.setProperty(String.format("%s.oauth.expiry", bookmark.getProtocol().getIdentifier()), tokens.expiryInMilliseconds.longValue());
        }
    }

    private String getPrefix(Host bookmark) {
        if (StringUtils.isNotBlank((CharSequence)bookmark.getCredentials().getUsername())) {
            return String.format("%s (%s)", bookmark.getProtocol().getDescription(), bookmark.getCredentials().getUsername());
        }
        return bookmark.getProtocol().getDescription();
    }

    public OAuth2AuthorizationService withMethod(Credential.AccessMethod method) {
        this.method = method;
        return this;
    }

    public OAuth2AuthorizationService withRedirectUri(String redirectUri) {
        this.redirectUri = redirectUri;
        return this;
    }

    public OAuth2AuthorizationService withParameter(String key, String value) {
        this.additionalParameters.put(key, value);
        return this;
    }

    public static final class Tokens {
        public static final Tokens EMPTY = new Tokens(null, null, Long.MAX_VALUE);
        private String accessToken;
        private String refreshToken;
        private Long expiryInMilliseconds;

        public Tokens(String accessToken, String refreshToken, Long expiryInMilliseconds) {
            this.accessToken = accessToken;
            this.refreshToken = refreshToken;
            this.expiryInMilliseconds = expiryInMilliseconds;
        }

        public boolean validate() {
            return StringUtils.isNotEmpty((CharSequence)this.accessToken);
        }

        public String getAccessToken() {
            return this.accessToken;
        }

        public String getRefreshToken() {
            return this.refreshToken;
        }

        public Long getExpiryInMilliseconds() {
            return this.expiryInMilliseconds;
        }

        public boolean isExpired() {
            return System.currentTimeMillis() >= this.expiryInMilliseconds;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("Tokens{");
            sb.append("accessToken='").append(this.accessToken).append('\'');
            sb.append(", refreshToken='").append(this.refreshToken).append('\'');
            sb.append('}');
            return sb.toString();
        }
    }
}

