/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.sds.io.swagger.client.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class CreateRoomRequest {
    @JsonProperty(value="parentId")
    private Long parentId = null;
    @JsonProperty(value="name")
    private String name = null;
    @JsonProperty(value="hasRecycleBin")
    private Boolean hasRecycleBin = null;
    @JsonProperty(value="recycleBinRetentionPeriod")
    private Integer recycleBinRetentionPeriod = null;
    @JsonProperty(value="quota")
    private Long quota = null;
    @JsonProperty(value="inheritPermissions")
    private Boolean inheritPermissions = null;
    @JsonProperty(value="adminIds")
    private List<Long> adminIds = null;
    @JsonProperty(value="adminGroupIds")
    private List<Long> adminGroupIds = null;
    @JsonProperty(value="newGroupMemberAcceptance")
    private String newGroupMemberAcceptance = null;
    @JsonProperty(value="notes")
    private String notes = null;

    public CreateRoomRequest parentId(Long parentId) {
        this.parentId = parentId;
        return this;
    }

    @ApiModelProperty(value="Parent Room Id or null to create a top-level room")
    public Long getParentId() {
        return this.parentId;
    }

    public void setParentId(Long parentId) {
        this.parentId = parentId;
    }

    public CreateRoomRequest name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(required=true, value="Name")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public CreateRoomRequest hasRecycleBin(Boolean hasRecycleBin) {
        this.hasRecycleBin = hasRecycleBin;
        return this;
    }

    @ApiModelProperty(value="Activate Recycle Bin")
    public Boolean getHasRecycleBin() {
        return this.hasRecycleBin;
    }

    public void setHasRecycleBin(Boolean hasRecycleBin) {
        this.hasRecycleBin = hasRecycleBin;
    }

    public CreateRoomRequest recycleBinRetentionPeriod(Integer recycleBinRetentionPeriod) {
        this.recycleBinRetentionPeriod = recycleBinRetentionPeriod;
        return this;
    }

    @ApiModelProperty(value="Retention period for deleted nodes in days. Integer between 0 and 9999.")
    public Integer getRecycleBinRetentionPeriod() {
        return this.recycleBinRetentionPeriod;
    }

    public void setRecycleBinRetentionPeriod(Integer recycleBinRetentionPeriod) {
        this.recycleBinRetentionPeriod = recycleBinRetentionPeriod;
    }

    public CreateRoomRequest quota(Long quota) {
        this.quota = quota;
        return this;
    }

    @ApiModelProperty(value="Quota in Byte")
    public Long getQuota() {
        return this.quota;
    }

    public void setQuota(Long quota) {
        this.quota = quota;
    }

    public CreateRoomRequest inheritPermissions(Boolean inheritPermissions) {
        this.inheritPermissions = inheritPermissions;
        return this;
    }

    @ApiModelProperty(value="Inherit permissions from parent room.")
    public Boolean getInheritPermissions() {
        return this.inheritPermissions;
    }

    public void setInheritPermissions(Boolean inheritPermissions) {
        this.inheritPermissions = inheritPermissions;
    }

    public CreateRoomRequest adminIds(List<Long> adminIds) {
        this.adminIds = adminIds;
        return this;
    }

    public CreateRoomRequest addAdminIdsItem(Long adminIdsItem) {
        if (this.adminIds == null) {
            this.adminIds = new ArrayList<Long>();
        }
        this.adminIds.add(adminIdsItem);
        return this;
    }

    @ApiModelProperty(value="List of user Ids. A room requires at least one admin (user or group)")
    public List<Long> getAdminIds() {
        return this.adminIds;
    }

    public void setAdminIds(List<Long> adminIds) {
        this.adminIds = adminIds;
    }

    public CreateRoomRequest adminGroupIds(List<Long> adminGroupIds) {
        this.adminGroupIds = adminGroupIds;
        return this;
    }

    public CreateRoomRequest addAdminGroupIdsItem(Long adminGroupIdsItem) {
        if (this.adminGroupIds == null) {
            this.adminGroupIds = new ArrayList<Long>();
        }
        this.adminGroupIds.add(adminGroupIdsItem);
        return this;
    }

    @ApiModelProperty(value="List of group Ids. A room requires at least one admin (user or group)")
    public List<Long> getAdminGroupIds() {
        return this.adminGroupIds;
    }

    public void setAdminGroupIds(List<Long> adminGroupIds) {
        this.adminGroupIds = adminGroupIds;
    }

    public CreateRoomRequest newGroupMemberAcceptance(String newGroupMemberAcceptance) {
        this.newGroupMemberAcceptance = newGroupMemberAcceptance;
        return this;
    }

    @ApiModelProperty(value="autoallow|pending; default:autoallow. Only relevant if adminGroupIds has items")
    public String getNewGroupMemberAcceptance() {
        return this.newGroupMemberAcceptance;
    }

    public void setNewGroupMemberAcceptance(String newGroupMemberAcceptance) {
        this.newGroupMemberAcceptance = newGroupMemberAcceptance;
    }

    public CreateRoomRequest notes(String notes) {
        this.notes = notes;
        return this;
    }

    @ApiModelProperty(value="User notes")
    public String getNotes() {
        return this.notes;
    }

    public void setNotes(String notes) {
        this.notes = notes;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CreateRoomRequest createRoomRequest = (CreateRoomRequest)o;
        return Objects.equals(this.parentId, createRoomRequest.parentId) && Objects.equals(this.name, createRoomRequest.name) && Objects.equals(this.hasRecycleBin, createRoomRequest.hasRecycleBin) && Objects.equals(this.recycleBinRetentionPeriod, createRoomRequest.recycleBinRetentionPeriod) && Objects.equals(this.quota, createRoomRequest.quota) && Objects.equals(this.inheritPermissions, createRoomRequest.inheritPermissions) && Objects.equals(this.adminIds, createRoomRequest.adminIds) && Objects.equals(this.adminGroupIds, createRoomRequest.adminGroupIds) && Objects.equals(this.newGroupMemberAcceptance, createRoomRequest.newGroupMemberAcceptance) && Objects.equals(this.notes, createRoomRequest.notes);
    }

    public int hashCode() {
        return Objects.hash(this.parentId, this.name, this.hasRecycleBin, this.recycleBinRetentionPeriod, this.quota, this.inheritPermissions, this.adminIds, this.adminGroupIds, this.newGroupMemberAcceptance, this.notes);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CreateRoomRequest {\n");
        sb.append("    parentId: ").append(this.toIndentedString(this.parentId)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    hasRecycleBin: ").append(this.toIndentedString(this.hasRecycleBin)).append("\n");
        sb.append("    recycleBinRetentionPeriod: ").append(this.toIndentedString(this.recycleBinRetentionPeriod)).append("\n");
        sb.append("    quota: ").append(this.toIndentedString(this.quota)).append("\n");
        sb.append("    inheritPermissions: ").append(this.toIndentedString(this.inheritPermissions)).append("\n");
        sb.append("    adminIds: ").append(this.toIndentedString(this.adminIds)).append("\n");
        sb.append("    adminGroupIds: ").append(this.toIndentedString(this.adminGroupIds)).append("\n");
        sb.append("    newGroupMemberAcceptance: ").append(this.toIndentedString(this.newGroupMemberAcceptance)).append("\n");
        sb.append("    notes: ").append(this.toIndentedString(this.notes)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

