/*
 * Decompiled with CFR 0.152.
 */
package com.joyent.manta.client.crypto;

import com.joyent.manta.client.crypto.ExternalSecurityProviderLoader;
import com.joyent.manta.client.crypto.SupportedCipherDetails;
import com.joyent.manta.client.crypto.SupportedHmacsLookupMap;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.time.Duration;
import java.time.Instant;
import java.util.Objects;
import java.util.function.Supplier;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.bouncycastle.crypto.macs.HMac;

public abstract class AbstractAesCipherDetails
implements SupportedCipherDetails {
    private static final Duration SEED_REFRESH_INTERVAL = Duration.ofHours(1L);
    protected static final String DEFAULT_HMAC_ALGORITHM = "HmacMD5";
    private final String hmacAlgorithm;
    private final int authenticationTagOrHmacLength;
    private final int keyLengthBits;
    private final String cipherId;
    private final String cipherAlgorithmJavaName;
    private final boolean isAEADCipher;
    private final SecureRandom random = AbstractAesCipherDetails.findSecureRandomImplementation();
    private volatile Instant seedLastRefreshedTimestamp = Instant.now();

    public AbstractAesCipherDetails(int keyLengthBits, String cipherAlgorithmJavaName, int authenticationTagLength) {
        this.keyLengthBits = keyLengthBits;
        this.cipherAlgorithmJavaName = cipherAlgorithmJavaName;
        this.cipherId = AbstractAesCipherDetails.createMantaCipherIdFromJavaAlgorithmId(cipherAlgorithmJavaName, keyLengthBits);
        this.hmacAlgorithm = null;
        this.authenticationTagOrHmacLength = authenticationTagLength;
        this.isAEADCipher = true;
    }

    public AbstractAesCipherDetails(int keyLengthBits, String cipherAlgorithmJavaName, String hmacAlgorithm) {
        this.keyLengthBits = keyLengthBits;
        this.cipherAlgorithmJavaName = cipherAlgorithmJavaName;
        this.cipherId = AbstractAesCipherDetails.createMantaCipherIdFromJavaAlgorithmId(cipherAlgorithmJavaName, keyLengthBits);
        this.hmacAlgorithm = hmacAlgorithm;
        this.authenticationTagOrHmacLength = this.getAuthenticationHmac().getMacSize();
        this.isAEADCipher = false;
    }

    @Override
    public String getKeyGenerationAlgorithm() {
        return "AES";
    }

    @Override
    public long getMaximumPlaintextSizeInBytes() {
        return Long.MAX_VALUE - (long)this.getAuthenticationTagOrHmacLengthInBytes();
    }

    @Override
    public int getAuthenticationTagOrHmacLengthInBytes() {
        return this.authenticationTagOrHmacLength;
    }

    @Override
    public int getBlockSizeInBytes() {
        return 16;
    }

    @Override
    public int getIVLengthInBytes() {
        return 16;
    }

    @Override
    public int getKeyLengthBits() {
        return this.keyLengthBits;
    }

    @Override
    public String getCipherId() {
        return this.cipherId;
    }

    @Override
    public String getCipherAlgorithm() {
        return this.cipherAlgorithmJavaName;
    }

    @Override
    public Cipher getCipher() {
        if (ExternalSecurityProviderLoader.getPkcs11Provider() == null) {
            return SupportedCipherDetails.findCipher(this.cipherAlgorithmJavaName, ExternalSecurityProviderLoader.getBouncyCastleProvider());
        }
        Provider provider = ExternalSecurityProviderLoader.getPkcs11Provider().containsKey("Cipher." + this.cipherAlgorithmJavaName) ? ExternalSecurityProviderLoader.getPkcs11Provider() : ExternalSecurityProviderLoader.getBouncyCastleProvider();
        return SupportedCipherDetails.findCipher(this.cipherAlgorithmJavaName, provider);
    }

    @Override
    public Cipher getBouncyCastleCipher() {
        return SupportedCipherDetails.findCipher(this.cipherAlgorithmJavaName, ExternalSecurityProviderLoader.getBouncyCastleProvider());
    }

    @Override
    public HMac getAuthenticationHmac() {
        if (this.isAEADCipher) {
            return null;
        }
        return (HMac)((Supplier)SupportedHmacsLookupMap.INSTANCE.get(this.hmacAlgorithm)).get();
    }

    @Override
    public AlgorithmParameterSpec getEncryptionParameterSpec(byte[] iv) {
        Validate.notNull((Object)iv, (String)"Initialization vector must not be null", (Object[])new Object[0]);
        Validate.isTrue((iv.length == this.getIVLengthInBytes() ? 1 : 0) != 0, (String)"Initialization vector has the wrong byte count [%d] expected [%d] bytes", (Object[])new Object[]{iv.length, this.getIVLengthInBytes()});
        return new IvParameterSpec(iv);
    }

    private static String createMantaCipherIdFromJavaAlgorithmId(String algorithm, int keyLengthBits) {
        int separator = 47;
        String[] parts = StringUtils.split((String)algorithm, (char)'/');
        if (parts.length < 3) {
            throw new IllegalArgumentException("There must be three slashes [/] in the algorithm name");
        }
        return parts[0] + keyLengthBits + '/' + parts[1] + '/' + parts[2];
    }

    @Override
    public boolean isAEADCipher() {
        return this.isAEADCipher;
    }

    @Override
    public byte[] generateIv() {
        byte[] iv = new byte[this.getIVLengthInBytes()];
        this.getSecureRandom().nextBytes(iv);
        return iv;
    }

    protected SecureRandom getSecureRandom() {
        Instant nextRefreshTimestamp = this.seedLastRefreshedTimestamp.plus(SEED_REFRESH_INTERVAL);
        if (this.seedLastRefreshedTimestamp.isAfter(nextRefreshTimestamp)) {
            this.random.setSeed(this.random.generateSeed(32));
            this.seedLastRefreshedTimestamp = Instant.now();
        }
        return this.random;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AbstractAesCipherDetails that = (AbstractAesCipherDetails)o;
        return this.authenticationTagOrHmacLength == that.authenticationTagOrHmacLength && this.keyLengthBits == that.keyLengthBits && this.isAEADCipher == that.isAEADCipher && Objects.equals(this.hmacAlgorithm, that.hmacAlgorithm) && Objects.equals(this.cipherId, that.cipherId) && Objects.equals(this.cipherAlgorithmJavaName, that.cipherAlgorithmJavaName);
    }

    public int hashCode() {
        return Objects.hash(this.hmacAlgorithm, this.authenticationTagOrHmacLength, this.keyLengthBits, this.cipherId, this.cipherAlgorithmJavaName, this.isAEADCipher);
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("hmacAlgorithm", (Object)this.hmacAlgorithm).append("authenticationTagOrHmacLength", this.authenticationTagOrHmacLength).append("keyLengthBits", this.keyLengthBits).append("cipherId", (Object)this.cipherId).append("cipherAlgorithmJavaName", (Object)this.cipherAlgorithmJavaName).append("isAEADCipher", this.isAEADCipher).toString();
    }

    private static SecureRandom findSecureRandomImplementation() {
        try {
            return SecureRandom.getInstance("NativePRNGNonBlocking", "SUN");
        }
        catch (NoSuchAlgorithmException | NoSuchProviderException e) {
            return new SecureRandom();
        }
    }
}

