/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.s3;

import ch.cyberduck.core.AbstractPath;
import ch.cyberduck.core.AttributedList;
import ch.cyberduck.core.ListProgressListener;
import ch.cyberduck.core.ListService;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathAttributes;
import ch.cyberduck.core.PathContainerService;
import ch.cyberduck.core.PathNormalizer;
import ch.cyberduck.core.Referenceable;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.io.Checksum;
import ch.cyberduck.core.preferences.Preferences;
import ch.cyberduck.core.preferences.PreferencesFactory;
import ch.cyberduck.core.s3.RequestEntityRestStorageService;
import ch.cyberduck.core.s3.S3AttributesFinderFeature;
import ch.cyberduck.core.s3.S3ExceptionMappingService;
import ch.cyberduck.core.s3.S3PathContainerService;
import ch.cyberduck.core.s3.S3Session;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.jets3t.service.ServiceException;
import org.jets3t.service.VersionOrDeleteMarkersChunk;
import org.jets3t.service.model.BaseVersionOrDeleteMarker;
import org.jets3t.service.model.S3Version;

public class S3VersionedObjectListService
implements ListService {
    private static final Logger log = Logger.getLogger(S3VersionedObjectListService.class);
    private final Preferences preferences = PreferencesFactory.get();
    private final PathContainerService containerService = new S3PathContainerService();
    private final S3Session session;
    private final S3AttributesFinderFeature attributes;

    public S3VersionedObjectListService(S3Session session) {
        this.session = session;
        this.attributes = new S3AttributesFinderFeature(session);
    }

    public AttributedList<Path> list(Path directory, ListProgressListener listener) throws BackgroundException {
        String prefix = this.createPrefix(directory);
        Path bucket = this.containerService.getContainer(directory);
        AttributedList children = new AttributedList();
        try {
            String priorLastKey = null;
            String priorLastVersionId = null;
            do {
                String[] prefixes;
                VersionOrDeleteMarkersChunk chunk = ((RequestEntityRestStorageService)((Object)this.session.getClient())).listVersionedObjectsChunked(bucket.getName(), prefix, String.valueOf('/'), this.preferences.getInteger("s3.listing.chunksize"), priorLastKey, priorLastVersionId, true);
                List<BaseVersionOrDeleteMarker> items = Arrays.asList(chunk.getItems());
                int i = 0;
                for (BaseVersionOrDeleteMarker marker : items) {
                    String key = PathNormalizer.normalize((String)marker.getKey());
                    if (String.valueOf('/').equals(key)) {
                        log.warn((Object)String.format("Skipping prefix %s", key));
                        continue;
                    }
                    if (new Path(bucket, key, EnumSet.of(AbstractPath.Type.directory)).equals((Object)directory)) continue;
                    PathAttributes attributes = new PathAttributes();
                    if (!StringUtils.equals((CharSequence)"null", (CharSequence)marker.getVersionId())) {
                        attributes.setVersionId(marker.getVersionId());
                    }
                    attributes.setRevision((long)(++i));
                    attributes.setDuplicate(marker.isDeleteMarker() && marker.isLatest() || !marker.isLatest());
                    attributes.setModificationDate(marker.getLastModified().getTime());
                    attributes.setRegion(bucket.attributes().getRegion());
                    if (marker instanceof S3Version) {
                        S3Version object = (S3Version)marker;
                        attributes.setSize(object.getSize());
                        if (StringUtils.isNotBlank((CharSequence)object.getEtag())) {
                            attributes.setChecksum(Checksum.parse((String)object.getEtag()));
                            attributes.setETag(object.getEtag());
                        }
                        if (StringUtils.isNotBlank((CharSequence)object.getStorageClass())) {
                            attributes.setStorageClass(object.getStorageClass());
                        }
                    }
                    Path f = new Path(directory, PathNormalizer.name((String)key), EnumSet.of(AbstractPath.Type.file), attributes);
                    children.add((Referenceable)f);
                }
                for (String common : prefixes = chunk.getCommonPrefixes()) {
                    if (String.valueOf('/').equals(common)) {
                        log.warn((Object)String.format("Skipping prefix %s", common));
                        continue;
                    }
                    String key = PathNormalizer.normalize((String)common);
                    if (new Path(bucket, key, EnumSet.of(AbstractPath.Type.directory)).equals((Object)directory)) continue;
                    PathAttributes attributes = new PathAttributes();
                    attributes.setRegion(bucket.attributes().getRegion());
                    Path file = new Path(String.format("%s%s%s", bucket.getAbsolute(), String.valueOf('/'), key), EnumSet.of(AbstractPath.Type.directory, AbstractPath.Type.placeholder), attributes);
                    children.add((Referenceable)file);
                }
                priorLastKey = chunk.getNextKeyMarker();
                priorLastVersionId = chunk.getNextVersionIdMarker();
                listener.chunk(directory, children);
            } while (priorLastKey != null);
            return children;
        }
        catch (ServiceException e) {
            throw new S3ExceptionMappingService().map("Listing directory {0} failed", e, directory);
        }
    }

    protected String createPrefix(Path directory) {
        String prefix = "";
        if (!this.containerService.isContainer(directory) && !(prefix = this.containerService.getKey(directory)).endsWith(String.valueOf('/'))) {
            prefix = prefix + '/';
        }
        return prefix;
    }
}

