/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.s3;

import ch.cyberduck.core.AbstractPath;
import ch.cyberduck.core.AttributedList;
import ch.cyberduck.core.DisabledListProgressListener;
import ch.cyberduck.core.Host;
import ch.cyberduck.core.HostKeyCallback;
import ch.cyberduck.core.HostPasswordStore;
import ch.cyberduck.core.ListProgressListener;
import ch.cyberduck.core.ListService;
import ch.cyberduck.core.LoginCallback;
import ch.cyberduck.core.PasswordCallback;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathAttributes;
import ch.cyberduck.core.PathNormalizer;
import ch.cyberduck.core.Referenceable;
import ch.cyberduck.core.Scheme;
import ch.cyberduck.core.Session;
import ch.cyberduck.core.TranscriptListener;
import ch.cyberduck.core.UrlProvider;
import ch.cyberduck.core.analytics.AnalyticsProvider;
import ch.cyberduck.core.analytics.QloudstatAnalyticsProvider;
import ch.cyberduck.core.auth.AWSSessionCredentialsRetriever;
import ch.cyberduck.core.cdn.Distribution;
import ch.cyberduck.core.cdn.DistributionConfiguration;
import ch.cyberduck.core.cloudfront.CloudFrontDistributionConfigurationPreloader;
import ch.cyberduck.core.cloudfront.WebsiteCloudFrontDistributionConfiguration;
import ch.cyberduck.core.exception.AccessDeniedException;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.exception.ConnectionRefusedException;
import ch.cyberduck.core.exception.ConnectionTimeoutException;
import ch.cyberduck.core.exception.InteroperabilityException;
import ch.cyberduck.core.exception.ListCanceledException;
import ch.cyberduck.core.exception.LoginFailureException;
import ch.cyberduck.core.exception.NotfoundException;
import ch.cyberduck.core.exception.ResolveFailedException;
import ch.cyberduck.core.features.AclPermission;
import ch.cyberduck.core.features.AttributesFinder;
import ch.cyberduck.core.features.Bulk;
import ch.cyberduck.core.features.Copy;
import ch.cyberduck.core.features.Delete;
import ch.cyberduck.core.features.Directory;
import ch.cyberduck.core.features.Encryption;
import ch.cyberduck.core.features.Find;
import ch.cyberduck.core.features.Headers;
import ch.cyberduck.core.features.Home;
import ch.cyberduck.core.features.IdProvider;
import ch.cyberduck.core.features.Lifecycle;
import ch.cyberduck.core.features.Location;
import ch.cyberduck.core.features.Logging;
import ch.cyberduck.core.features.Metadata;
import ch.cyberduck.core.features.Move;
import ch.cyberduck.core.features.MultipartWrite;
import ch.cyberduck.core.features.Read;
import ch.cyberduck.core.features.Redundancy;
import ch.cyberduck.core.features.Scheduler;
import ch.cyberduck.core.features.Search;
import ch.cyberduck.core.features.Touch;
import ch.cyberduck.core.features.TransferAcceleration;
import ch.cyberduck.core.features.Upload;
import ch.cyberduck.core.features.Versioning;
import ch.cyberduck.core.features.Write;
import ch.cyberduck.core.http.HttpSession;
import ch.cyberduck.core.iam.AmazonIdentityConfiguration;
import ch.cyberduck.core.identity.IdentityConfiguration;
import ch.cyberduck.core.kms.KMSEncryptionFeature;
import ch.cyberduck.core.preferences.Preferences;
import ch.cyberduck.core.preferences.PreferencesFactory;
import ch.cyberduck.core.proxy.Proxy;
import ch.cyberduck.core.s3.LaxHostnameDelegatingTrustManager;
import ch.cyberduck.core.s3.RequestEntityRestStorageService;
import ch.cyberduck.core.s3.S3AccessControlListFeature;
import ch.cyberduck.core.s3.S3AttributesFinderFeature;
import ch.cyberduck.core.s3.S3BucketListService;
import ch.cyberduck.core.s3.S3BulkTransferAccelerationFeature;
import ch.cyberduck.core.s3.S3CopyFeature;
import ch.cyberduck.core.s3.S3DefaultDeleteFeature;
import ch.cyberduck.core.s3.S3DefaultMultipartService;
import ch.cyberduck.core.s3.S3DirectoryFeature;
import ch.cyberduck.core.s3.S3DisabledMultipartService;
import ch.cyberduck.core.s3.S3ExceptionMappingService;
import ch.cyberduck.core.s3.S3FindFeature;
import ch.cyberduck.core.s3.S3HomeFinderService;
import ch.cyberduck.core.s3.S3LifecycleConfiguration;
import ch.cyberduck.core.s3.S3LocationFeature;
import ch.cyberduck.core.s3.S3LoggingFeature;
import ch.cyberduck.core.s3.S3MetadataFeature;
import ch.cyberduck.core.s3.S3MoveFeature;
import ch.cyberduck.core.s3.S3MultipartWriteFeature;
import ch.cyberduck.core.s3.S3MultipleDeleteFeature;
import ch.cyberduck.core.s3.S3ObjectListService;
import ch.cyberduck.core.s3.S3Protocol;
import ch.cyberduck.core.s3.S3ReadFeature;
import ch.cyberduck.core.s3.S3SearchFeature;
import ch.cyberduck.core.s3.S3StorageClassFeature;
import ch.cyberduck.core.s3.S3ThresholdCopyFeature;
import ch.cyberduck.core.s3.S3ThresholdUploadService;
import ch.cyberduck.core.s3.S3TouchFeature;
import ch.cyberduck.core.s3.S3TransferAccelerationService;
import ch.cyberduck.core.s3.S3UrlProvider;
import ch.cyberduck.core.s3.S3VersionIdProvider;
import ch.cyberduck.core.s3.S3VersionedObjectListService;
import ch.cyberduck.core.s3.S3VersioningFeature;
import ch.cyberduck.core.s3.S3WriteFeature;
import ch.cyberduck.core.shared.DelegatingSchedulerFeature;
import ch.cyberduck.core.shared.DisabledBulkFeature;
import ch.cyberduck.core.ssl.DefaultX509KeyManager;
import ch.cyberduck.core.ssl.DisabledX509TrustManager;
import ch.cyberduck.core.ssl.ThreadLocalHostnameDelegatingTrustManager;
import ch.cyberduck.core.ssl.X509KeyManager;
import ch.cyberduck.core.ssl.X509TrustManager;
import ch.cyberduck.core.threading.CancelCallback;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.log4j.Logger;
import org.jets3t.service.Jets3tProperties;
import org.jets3t.service.ServiceException;
import org.jets3t.service.impl.rest.XmlResponsesSaxParser;
import org.jets3t.service.model.MultipartUpload;
import org.jets3t.service.security.AWSCredentials;
import org.jets3t.service.security.ProviderCredentials;

public class S3Session
extends HttpSession<RequestEntityRestStorageService> {
    private static final Logger log = Logger.getLogger(S3Session.class);
    private final Preferences preferences = PreferencesFactory.get();
    private Versioning versioning = new S3VersioningFeature(this, new S3AccessControlListFeature(this));
    private Map<Path, Distribution> distributions = Collections.emptyMap();
    private S3Protocol.AuthenticationHeaderSignatureVersion authenticationHeaderSignatureVersion = S3Protocol.AuthenticationHeaderSignatureVersion.getDefault(this.host.getProtocol());

    public S3Session(Host host) {
        super(host, (ThreadLocalHostnameDelegatingTrustManager)(host.getHostname().endsWith(PreferencesFactory.get().getProperty("s3.hostname.default")) ? new LaxHostnameDelegatingTrustManager((X509TrustManager)new DisabledX509TrustManager(), host.getHostname()) : new ThreadLocalHostnameDelegatingTrustManager((X509TrustManager)new DisabledX509TrustManager(), host.getHostname())), (X509KeyManager)new DefaultX509KeyManager());
    }

    public S3Session(Host host, X509TrustManager trust, X509KeyManager key) {
        super(host, (ThreadLocalHostnameDelegatingTrustManager)(host.getHostname().endsWith(PreferencesFactory.get().getProperty("s3.hostname.default")) ? new LaxHostnameDelegatingTrustManager(trust, host.getHostname()) : new ThreadLocalHostnameDelegatingTrustManager(trust, host.getHostname())), key);
    }

    protected void logout() throws BackgroundException {
        try {
            ((RequestEntityRestStorageService)((Object)this.client)).shutdown();
        }
        catch (ServiceException e) {
            throw new S3ExceptionMappingService().map(e);
        }
    }

    protected boolean authorize(HttpUriRequest httpMethod, ProviderCredentials credentials) throws ServiceException {
        return false;
    }

    protected XmlResponsesSaxParser getXmlResponseSaxParser() throws ServiceException {
        return new XmlResponsesSaxParser(((RequestEntityRestStorageService)((Object)this.client)).getJetS3tProperties(), false);
    }

    protected String getSignatureIdentifier() {
        return "AWS";
    }

    public S3Protocol.AuthenticationHeaderSignatureVersion getSignatureVersion() {
        return this.authenticationHeaderSignatureVersion;
    }

    public void setSignatureVersion(S3Protocol.AuthenticationHeaderSignatureVersion authenticationHeaderSignatureVersion) {
        this.authenticationHeaderSignatureVersion = authenticationHeaderSignatureVersion;
    }

    protected String getRestHeaderPrefix() {
        return "x-amz-";
    }

    protected String getRestMetadataPrefix() {
        return "x-amz-meta-";
    }

    protected Jets3tProperties configure() {
        Jets3tProperties configuration = new Jets3tProperties();
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Configure for endpoint %s", this.host));
        }
        if (this.host.getHostname().endsWith(this.preferences.getProperty("s3.hostname.default"))) {
            configuration.setProperty("s3service.s3-endpoint", this.preferences.getProperty("s3.hostname.default"));
            configuration.setProperty("s3service.disable-dns-buckets", String.valueOf(this.preferences.getBoolean("s3.bucket.virtualhost.disable")));
        } else {
            configuration.setProperty("s3service.s3-endpoint", this.host.getHostname());
            configuration.setProperty("s3service.disable-dns-buckets", String.valueOf(true));
        }
        configuration.setProperty("s3service.enable-storage-classes", String.valueOf(true));
        if (StringUtils.isNotBlank((CharSequence)this.host.getProtocol().getContext()) && !Scheme.isURL((String)this.host.getProtocol().getContext())) {
            configuration.setProperty("s3service.s3-endpoint-virtual-path", PathNormalizer.normalize((String)this.host.getProtocol().getContext()));
        }
        configuration.setProperty("s3service.https-only", String.valueOf(this.host.getProtocol().isSecure()));
        if (this.host.getProtocol().isSecure()) {
            configuration.setProperty("s3service.s3-endpoint-https-port", String.valueOf(this.host.getPort()));
        } else {
            configuration.setProperty("s3service.s3-endpoint-http-port", String.valueOf(this.host.getPort()));
        }
        configuration.setProperty("s3service.internal-error-retry-max", String.valueOf(0));
        configuration.setProperty("s3service.max-thread-count", String.valueOf(1));
        configuration.setProperty("httpclient.proxy-autodetect", String.valueOf(false));
        configuration.setProperty("httpclient.retry-max", String.valueOf(0));
        configuration.setProperty("storage-service.internal-error-retry-max", String.valueOf(0));
        configuration.setProperty("storage-service.request-signature-version", this.authenticationHeaderSignatureVersion.toString());
        configuration.setProperty("storage-service.disable-live-md5", String.valueOf(true));
        configuration.setProperty("storage-service.default-region", this.host.getRegion());
        return configuration;
    }

    public RequestEntityRestStorageService connect(Proxy proxy, HostKeyCallback key, LoginCallback prompt) throws BackgroundException {
        return new RequestEntityRestStorageService(this, this.configure(), this.builder.build(proxy, (TranscriptListener)this, prompt));
    }

    public void login(Proxy proxy, HostPasswordStore keychain, LoginCallback prompt, CancelCallback cancel) throws BackgroundException {
        if (Scheme.isURL((String)this.host.getProtocol().getContext())) {
            try {
                ((RequestEntityRestStorageService)((Object)this.client)).setProviderCredentials((ProviderCredentials)new AWSSessionCredentialsRetriever(this.trust, this.key, (TranscriptListener)this, this.host.getProtocol().getContext()).get());
            }
            catch (ConnectionRefusedException | ConnectionTimeoutException | InteroperabilityException | NotfoundException | ResolveFailedException e) {
                log.warn((Object)String.format("Failure to retrieve session credentials from . %s", e.getMessage()));
                throw new LoginFailureException(e.getDetail(false), e);
            }
        } else {
            ((RequestEntityRestStorageService)((Object)this.client)).setProviderCredentials((ProviderCredentials)(this.host.getCredentials().isAnonymousLogin() ? null : new AWSCredentials(this.host.getCredentials().getUsername(), this.host.getCredentials().getPassword())));
        }
        if (this.host.getCredentials().isPassed()) {
            log.warn((Object)String.format("Skip verifying credentials with previous successful authentication event for %s", new Object[]{this}));
            return;
        }
        try {
            ((ListService)this.getFeature(ListService.class)).list(new S3HomeFinderService((Session)this).find(), (ListProgressListener)new DisabledListProgressListener(){

                public void chunk(Path parent, AttributedList<Path> list) throws ListCanceledException {
                    throw new ListCanceledException(list);
                }
            });
        }
        catch (ListCanceledException listCanceledException) {
            // empty catch block
        }
    }

    public AttributedList<Path> list(Path directory, ListProgressListener listener) throws BackgroundException {
        AttributedList<Path> objects;
        if (directory.isRoot()) {
            return new S3BucketListService(this, new S3LocationFeature.S3Region(this.host.getRegion())).list(directory, listener);
        }
        try {
            objects = new S3VersionedObjectListService(this).list(directory, listener);
        }
        catch (AccessDeniedException | InteroperabilityException e) {
            log.warn((Object)String.format("Ignore failure listing versioned objects. %s", e.getDetail()));
            objects = new S3ObjectListService(this).list(directory, listener);
        }
        try {
            for (MultipartUpload upload : new S3DefaultMultipartService(this).find(directory)) {
                PathAttributes attributes = new PathAttributes();
                attributes.setVersionId(upload.getUploadId());
                attributes.setModificationDate(upload.getInitiatedDate().getTime());
                objects.add((Referenceable)new Path(directory, upload.getObjectKey(), EnumSet.of(AbstractPath.Type.file, AbstractPath.Type.upload), attributes));
            }
        }
        catch (AccessDeniedException | InteroperabilityException e) {
            log.warn((Object)String.format("Ignore failure listing incomplete multipart uploads. %s", e.getDetail()));
        }
        return objects;
    }

    public <T> T _getFeature(Class<T> type) {
        if (type == Read.class) {
            return (T)new S3ReadFeature(this);
        }
        if (type == MultipartWrite.class) {
            if (this.host.getHostname().endsWith(this.preferences.getProperty("s3.hostname.default"))) {
                return (T)new S3MultipartWriteFeature(this);
            }
            return (T)new S3MultipartWriteFeature(this);
        }
        if (type == Write.class) {
            return (T)((Object)new S3WriteFeature(this));
        }
        if (type == Upload.class) {
            return (T)new S3ThresholdUploadService(this);
        }
        if (type == Directory.class) {
            return (T)new S3DirectoryFeature(this, new S3WriteFeature(this, new S3DisabledMultipartService()));
        }
        if (type == Move.class) {
            return (T)new S3MoveFeature(this);
        }
        if (type == Copy.class) {
            if (this.host.getHostname().endsWith(this.preferences.getProperty("s3.hostname.default"))) {
                return (T)new S3ThresholdCopyFeature(this);
            }
            return (T)new S3CopyFeature(this);
        }
        if (type == Delete.class) {
            if (this.host.getHostname().endsWith(this.preferences.getProperty("s3.hostname.default"))) {
                return (T)new S3MultipleDeleteFeature(this);
            }
            return (T)new S3DefaultDeleteFeature(this);
        }
        if (type == AclPermission.class) {
            return (T)((Object)new S3AccessControlListFeature(this));
        }
        if (type == Headers.class) {
            return (T)new S3MetadataFeature(this, new S3AccessControlListFeature(this));
        }
        if (type == Metadata.class) {
            return (T)new S3MetadataFeature(this, new S3AccessControlListFeature(this));
        }
        if (type == Touch.class) {
            return (T)new S3TouchFeature(this);
        }
        if (type == Location.class) {
            if (this.isConnected()) {
                return (T)new S3LocationFeature(this, ((RequestEntityRestStorageService)((Object)this.client)).getRegionEndpointCache());
            }
            return (T)new S3LocationFeature(this);
        }
        if (type == AnalyticsProvider.class) {
            if (this.host.getHostname().endsWith(this.preferences.getProperty("s3.hostname.default"))) {
                return (T)new QloudstatAnalyticsProvider();
            }
            return null;
        }
        if (type == Versioning.class) {
            return (T)this.versioning;
        }
        if (type == Logging.class) {
            return (T)new S3LoggingFeature(this);
        }
        if (type == Lifecycle.class) {
            return (T)new S3LifecycleConfiguration(this);
        }
        if (type == Encryption.class) {
            if (this.host.getHostname().endsWith(this.preferences.getProperty("s3.hostname.default"))) {
                return (T)new KMSEncryptionFeature(this);
            }
            return null;
        }
        if (type == Redundancy.class) {
            return (T)new S3StorageClassFeature(this);
        }
        if (type == IdentityConfiguration.class) {
            if (this.host.getHostname().endsWith(this.preferences.getProperty("s3.hostname.default"))) {
                return (T)new AmazonIdentityConfiguration(this.host);
            }
            return null;
        }
        if (type == DistributionConfiguration.class) {
            return (T)new WebsiteCloudFrontDistributionConfiguration(this, this.distributions, this.trust, this.key);
        }
        if (type == UrlProvider.class) {
            return (T)new S3UrlProvider(this);
        }
        if (type == Find.class) {
            return (T)new S3FindFeature(this);
        }
        if (type == AttributesFinder.class) {
            return (T)new S3AttributesFinderFeature(this);
        }
        if (type == Home.class) {
            return (T)((Object)new S3HomeFinderService((Session)this));
        }
        if (type == TransferAcceleration.class) {
            if (this.host.getHostname().endsWith(this.preferences.getProperty("s3.hostname.default"))) {
                return (T)new S3TransferAccelerationService(this);
            }
            return null;
        }
        if (type == Bulk.class) {
            if (this.host.getHostname().endsWith(this.preferences.getProperty("s3.hostname.default"))) {
                return (T)new S3BulkTransferAccelerationFeature(this, new S3TransferAccelerationService(this));
            }
            return (T)new DisabledBulkFeature();
        }
        if (type == Search.class) {
            return (T)new S3SearchFeature(this);
        }
        if (type == IdProvider.class) {
            return (T)new S3VersionIdProvider(this);
        }
        if (type == Scheduler.class) {
            return (T)new DelegatingSchedulerFeature(new Scheduler[]{new CloudFrontDistributionConfigurationPreloader(this){

                @Override
                public Map<Path, Distribution> operate(PasswordCallback callback, Path container) throws BackgroundException {
                    return S3Session.this.distributions = (Map)super.operate(callback, container);
                }
            }});
        }
        return (T)super._getFeature(type);
    }
}

