/*
 * Decompiled with CFR 0.152.
 */
package com.spectralogic.ds3client.helpers;

import com.spectralogic.ds3client.helpers.Ds3ClientHelpers;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;

public class FileObjectPutter
implements Ds3ClientHelpers.ObjectChannelBuilder {
    private final Path root;

    public FileObjectPutter(Path root) {
        this.root = root;
    }

    @Override
    public SeekableByteChannel buildChannel(String key) throws IOException {
        Path path = this.root.resolve(key);
        return FileChannel.open(FileObjectPutter.resolveForSymbolic(path), StandardOpenOption.READ);
    }

    private static Path resolveForSymbolic(Path path) throws IOException {
        if (Files.isSymbolicLink(path)) {
            Path simLink = Files.readSymbolicLink(path);
            if (!simLink.isAbsolute()) {
                Path symLinkParent = path.toAbsolutePath().getParent();
                return symLinkParent.resolve(simLink);
            }
            return simLink;
        }
        return path;
    }
}

