/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.openstack;

import ch.cyberduck.core.AbstractPath;
import ch.cyberduck.core.AttributedList;
import ch.cyberduck.core.DefaultIOExceptionMappingService;
import ch.cyberduck.core.ListProgressListener;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathAttributes;
import ch.cyberduck.core.Referenceable;
import ch.cyberduck.core.RootListService;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.openstack.SwiftExceptionMappingService;
import ch.cyberduck.core.openstack.SwiftLocationFeature;
import ch.cyberduck.core.openstack.SwiftSession;
import ch.cyberduck.core.preferences.Preferences;
import ch.cyberduck.core.preferences.PreferencesFactory;
import ch.iterate.openstack.swift.Client;
import ch.iterate.openstack.swift.exception.GenericException;
import ch.iterate.openstack.swift.model.Container;
import ch.iterate.openstack.swift.model.Region;
import java.io.IOException;
import java.util.EnumSet;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public class SwiftContainerListService
implements RootListService {
    private static final Logger log = Logger.getLogger(SwiftContainerListService.class);
    private final SwiftSession session;
    private final Preferences preferences = PreferencesFactory.get();
    private final SwiftLocationFeature.SwiftRegion region;

    public SwiftContainerListService(SwiftSession session, SwiftLocationFeature.SwiftRegion region) {
        this.session = session;
        this.region = region;
    }

    public AttributedList<Path> list(Path directory, ListProgressListener listener) throws BackgroundException {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("List containers for %s", new Object[]{this.session}));
        }
        try {
            AttributedList containers = new AttributedList();
            int limit = this.preferences.getInteger("openstack.list.container.limit");
            Client client = (Client)this.session.getClient();
            for (Region region : client.getRegions()) {
                List chunk;
                if (this.region.getIdentifier() != null && !StringUtils.equals((CharSequence)region.getRegionId(), (CharSequence)this.region.getIdentifier())) {
                    log.warn((Object)String.format("Skip region %s", region));
                    continue;
                }
                String marker = null;
                do {
                    chunk = client.listContainers(region, limit, marker);
                    for (Container f : chunk) {
                        PathAttributes attributes = new PathAttributes();
                        attributes.setRegion(f.getRegion().getRegionId());
                        containers.add((Referenceable)new Path(String.format("/%s", f.getName()), EnumSet.of(AbstractPath.Type.volume, AbstractPath.Type.directory), attributes));
                        marker = f.getName();
                    }
                    listener.chunk(directory, containers);
                } while (!chunk.isEmpty());
            }
            return containers;
        }
        catch (GenericException e) {
            throw new SwiftExceptionMappingService().map("Listing directory {0} failed", e, directory);
        }
        catch (IOException e) {
            throw new DefaultIOExceptionMappingService().map(e);
        }
    }
}

