/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.sds.triplecrypt;

import ch.cyberduck.core.sds.io.swagger.client.model.FileKey;
import ch.cyberduck.core.sds.io.swagger.client.model.FileKeyContainer;
import ch.cyberduck.core.sds.io.swagger.client.model.PrivateKeyContainer;
import ch.cyberduck.core.sds.io.swagger.client.model.PublicKeyContainer;
import ch.cyberduck.core.sds.io.swagger.client.model.UserKeyPairContainer;
import com.dracoon.sdk.crypto.model.EncryptedFileKey;
import com.dracoon.sdk.crypto.model.PlainFileKey;
import com.dracoon.sdk.crypto.model.UserKeyPair;
import com.dracoon.sdk.crypto.model.UserPublicKey;

public class TripleCryptConverter {
    public static FileKey toSwaggerFileKey(EncryptedFileKey k) {
        return new FileKey().key(k.getKey()).iv(k.getIv()).tag(k.getTag()).version(k.getVersion());
    }

    public static FileKey toSwaggerFileKey(PlainFileKey k) {
        return new FileKey().key(k.getKey()).iv(k.getIv()).tag(k.getTag()).version(k.getVersion());
    }

    public static UserKeyPairContainer toSwaggerUserKeyPairContainer(UserKeyPair pair) {
        UserKeyPairContainer container = new UserKeyPairContainer();
        container.setPrivateKeyContainer(new PrivateKeyContainer().privateKey(pair.getUserPrivateKey().getPrivateKey()).version(pair.getUserPrivateKey().getVersion()));
        container.setPublicKeyContainer(new PublicKeyContainer().publicKey(pair.getUserPublicKey().getPublicKey()).version(pair.getUserPublicKey().getVersion()));
        return container;
    }

    public static UserPublicKey toCryptoUserPublicKey(PublicKeyContainer c) {
        UserPublicKey key = new UserPublicKey();
        key.setPublicKey(c.getPublicKey());
        key.setVersion(c.getVersion());
        return key;
    }

    public static PlainFileKey toCryptoPlainFileKey(FileKey key) {
        PlainFileKey fileKey = new PlainFileKey();
        fileKey.setKey(key.getKey());
        fileKey.setIv(key.getIv());
        fileKey.setTag(key.getTag());
        fileKey.setVersion(key.getVersion());
        return fileKey;
    }

    public static EncryptedFileKey toCryptoEncryptedFileKey(FileKeyContainer key) {
        EncryptedFileKey fileKey = new EncryptedFileKey();
        fileKey.setKey(key.getKey());
        fileKey.setIv(key.getIv());
        fileKey.setTag(key.getTag());
        fileKey.setVersion(key.getVersion());
        return fileKey;
    }

    public static EncryptedFileKey toCryptoEncryptedFileKey(FileKey k) {
        EncryptedFileKey key = new EncryptedFileKey();
        key.setKey(k.getKey());
        key.setIv(k.getIv());
        key.setTag(k.getTag());
        key.setVersion(k.getVersion());
        return key;
    }
}

