/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.sds.io.swagger.client.api;

import ch.cyberduck.core.sds.io.swagger.client.ApiClient;
import ch.cyberduck.core.sds.io.swagger.client.ApiException;
import ch.cyberduck.core.sds.io.swagger.client.Configuration;
import ch.cyberduck.core.sds.io.swagger.client.Pair;
import ch.cyberduck.core.sds.io.swagger.client.model.GroupIds;
import ch.cyberduck.core.sds.io.swagger.client.model.RoleGroupList;
import ch.cyberduck.core.sds.io.swagger.client.model.RoleList;
import ch.cyberduck.core.sds.io.swagger.client.model.RoleUserList;
import ch.cyberduck.core.sds.io.swagger.client.model.UserIds;
import java.util.ArrayList;
import java.util.HashMap;
import javax.ws.rs.core.GenericType;

public class RolesApi {
    private ApiClient apiClient;

    public RolesApi() {
        this(Configuration.getDefaultApiClient());
    }

    public RolesApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public RoleGroupList addRoleGroups(String xSdsAuthToken, Integer roleId, GroupIds body) throws ApiException {
        GroupIds localVarPostBody = body;
        if (xSdsAuthToken == null) {
            throw new ApiException(400, "Missing the required parameter 'xSdsAuthToken' when calling addRoleGroups");
        }
        if (roleId == null) {
            throw new ApiException(400, "Missing the required parameter 'roleId' when calling addRoleGroups");
        }
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling addRoleGroups");
        }
        String localVarPath = "/roles/{role_id}/groups".replaceAll("\\{role_id\\}", this.apiClient.escapeString(roleId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (xSdsAuthToken != null) {
            localVarHeaderParams.put("X-Sds-Auth-Token", this.apiClient.parameterToString(xSdsAuthToken));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        GenericType<RoleGroupList> localVarReturnType = new GenericType<RoleGroupList>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public RoleUserList addRoleUsers(String xSdsAuthToken, Integer roleId, UserIds body) throws ApiException {
        UserIds localVarPostBody = body;
        if (xSdsAuthToken == null) {
            throw new ApiException(400, "Missing the required parameter 'xSdsAuthToken' when calling addRoleUsers");
        }
        if (roleId == null) {
            throw new ApiException(400, "Missing the required parameter 'roleId' when calling addRoleUsers");
        }
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling addRoleUsers");
        }
        String localVarPath = "/roles/{role_id}/users".replaceAll("\\{role_id\\}", this.apiClient.escapeString(roleId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (xSdsAuthToken != null) {
            localVarHeaderParams.put("X-Sds-Auth-Token", this.apiClient.parameterToString(xSdsAuthToken));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        GenericType<RoleUserList> localVarReturnType = new GenericType<RoleUserList>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public RoleGroupList deleteRoleGroups(String xSdsAuthToken, Integer roleId, GroupIds body) throws ApiException {
        GroupIds localVarPostBody = body;
        if (xSdsAuthToken == null) {
            throw new ApiException(400, "Missing the required parameter 'xSdsAuthToken' when calling deleteRoleGroups");
        }
        if (roleId == null) {
            throw new ApiException(400, "Missing the required parameter 'roleId' when calling deleteRoleGroups");
        }
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling deleteRoleGroups");
        }
        String localVarPath = "/roles/{role_id}/groups".replaceAll("\\{role_id\\}", this.apiClient.escapeString(roleId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (xSdsAuthToken != null) {
            localVarHeaderParams.put("X-Sds-Auth-Token", this.apiClient.parameterToString(xSdsAuthToken));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        GenericType<RoleGroupList> localVarReturnType = new GenericType<RoleGroupList>(){};
        return this.apiClient.invokeAPI(localVarPath, "DELETE", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public RoleUserList deleteRoleUsers(String xSdsAuthToken, Integer roleId, UserIds body) throws ApiException {
        UserIds localVarPostBody = body;
        if (xSdsAuthToken == null) {
            throw new ApiException(400, "Missing the required parameter 'xSdsAuthToken' when calling deleteRoleUsers");
        }
        if (roleId == null) {
            throw new ApiException(400, "Missing the required parameter 'roleId' when calling deleteRoleUsers");
        }
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling deleteRoleUsers");
        }
        String localVarPath = "/roles/{role_id}/users".replaceAll("\\{role_id\\}", this.apiClient.escapeString(roleId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (xSdsAuthToken != null) {
            localVarHeaderParams.put("X-Sds-Auth-Token", this.apiClient.parameterToString(xSdsAuthToken));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        GenericType<RoleUserList> localVarReturnType = new GenericType<RoleUserList>(){};
        return this.apiClient.invokeAPI(localVarPath, "DELETE", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public RoleGroupList getRoleGroups(String xSdsAuthToken, Integer roleId, Integer offset, Integer limit, String filter) throws ApiException {
        Object localVarPostBody = null;
        if (xSdsAuthToken == null) {
            throw new ApiException(400, "Missing the required parameter 'xSdsAuthToken' when calling getRoleGroups");
        }
        if (roleId == null) {
            throw new ApiException(400, "Missing the required parameter 'roleId' when calling getRoleGroups");
        }
        String localVarPath = "/roles/{role_id}/groups".replaceAll("\\{role_id\\}", this.apiClient.escapeString(roleId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "offset", offset));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "limit", limit));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter", filter));
        if (xSdsAuthToken != null) {
            localVarHeaderParams.put("X-Sds-Auth-Token", this.apiClient.parameterToString(xSdsAuthToken));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        GenericType<RoleGroupList> localVarReturnType = new GenericType<RoleGroupList>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public RoleUserList getRoleUsers(String xSdsAuthToken, Integer roleId, Integer offset, Integer limit, String filter) throws ApiException {
        Object localVarPostBody = null;
        if (xSdsAuthToken == null) {
            throw new ApiException(400, "Missing the required parameter 'xSdsAuthToken' when calling getRoleUsers");
        }
        if (roleId == null) {
            throw new ApiException(400, "Missing the required parameter 'roleId' when calling getRoleUsers");
        }
        String localVarPath = "/roles/{role_id}/users".replaceAll("\\{role_id\\}", this.apiClient.escapeString(roleId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "offset", offset));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "limit", limit));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter", filter));
        if (xSdsAuthToken != null) {
            localVarHeaderParams.put("X-Sds-Auth-Token", this.apiClient.parameterToString(xSdsAuthToken));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        GenericType<RoleUserList> localVarReturnType = new GenericType<RoleUserList>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public RoleList getRoles(String xSdsAuthToken) throws ApiException {
        Object localVarPostBody = null;
        if (xSdsAuthToken == null) {
            throw new ApiException(400, "Missing the required parameter 'xSdsAuthToken' when calling getRoles");
        }
        String localVarPath = "/roles";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (xSdsAuthToken != null) {
            localVarHeaderParams.put("X-Sds-Auth-Token", this.apiClient.parameterToString(xSdsAuthToken));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        GenericType<RoleList> localVarReturnType = new GenericType<RoleList>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }
}

