/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.sds;

import ch.cyberduck.core.Acl;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.exception.UnsupportedException;
import ch.cyberduck.core.sds.SDSAttributesFinderFeature;
import ch.cyberduck.core.sds.SDSSession;
import ch.cyberduck.core.shared.DefaultAclFeature;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class SDSPermissionsFeature
extends DefaultAclFeature {
    public static final Acl.Role MANAGE_ROLE = new Acl.Role("MANAGE_ROLE");
    public static final Acl.Role READ_ROLE = new Acl.Role("READ");
    public static final Acl.Role CREATE_ROLE = new Acl.Role("CREATE");
    public static final Acl.Role CHANGE_ROLE = new Acl.Role("CHANGE");
    public static final Acl.Role DELETE_ROLE = new Acl.Role("DELETE");
    public static final Acl.Role DOWNLOAD_SHARE_ROLE = new Acl.Role("DOWNLOAD_SHARE");
    public static final Acl.Role UPLOAD_SHARE_ROLE = new Acl.Role("UPLOAD_SHARE");
    private final SDSSession session;

    public SDSPermissionsFeature(SDSSession session) {
        this.session = session;
    }

    public Acl getPermission(Path file) throws BackgroundException {
        if (Acl.EMPTY.equals((Object)file.attributes().getAcl())) {
            return new SDSAttributesFinderFeature(this.session).find(file).getAcl();
        }
        return file.attributes().getAcl();
    }

    public void setPermission(Path file, Acl acl) throws BackgroundException {
        throw new UnsupportedException();
    }

    public List<Acl.User> getAvailableAclUsers() {
        try {
            return Collections.singletonList(new Acl.CanonicalUser(String.valueOf(this.session.userAccount().getId())));
        }
        catch (BackgroundException e) {
            return Collections.emptyList();
        }
    }

    public List<Acl.Role> getAvailableAclRoles(List<Path> files) {
        return Arrays.asList(MANAGE_ROLE, READ_ROLE, CREATE_ROLE, CHANGE_ROLE, DELETE_ROLE, DOWNLOAD_SHARE_ROLE, UPLOAD_SHARE_ROLE);
    }
}

