/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.googledrive;

import ch.cyberduck.core.DisabledListProgressListener;
import ch.cyberduck.core.ListProgressListener;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathAttributes;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.Directory;
import ch.cyberduck.core.features.Write;
import ch.cyberduck.core.googledrive.DriveExceptionMappingService;
import ch.cyberduck.core.googledrive.DriveFileidProvider;
import ch.cyberduck.core.googledrive.DriveSession;
import ch.cyberduck.core.preferences.PreferencesFactory;
import ch.cyberduck.core.transfer.TransferStatus;
import com.google.api.services.drive.Drive;
import com.google.api.services.drive.model.File;
import java.io.IOException;
import java.util.Collections;

public class DriveDirectoryFeature
implements Directory<Void> {
    private final DriveSession session;

    public DriveDirectoryFeature(DriveSession session) {
        this.session = session;
    }

    public Path mkdir(Path folder, String region, TransferStatus status) throws BackgroundException {
        try {
            Drive.Files.Create insert = ((Drive)this.session.getClient()).files().create(new File().setName(folder.getName()).setMimeType("application/vnd.google-apps.folder").setParents(Collections.singletonList(new DriveFileidProvider(this.session).getFileid(folder.getParent(), (ListProgressListener)new DisabledListProgressListener()))));
            File execute = (File)insert.setSupportsTeamDrives(Boolean.valueOf(PreferencesFactory.get().getBoolean("googledrive.teamdrive.enable"))).execute();
            return new Path(folder.getParent(), folder.getName(), folder.getType(), new PathAttributes(folder.attributes()));
        }
        catch (IOException e) {
            throw new DriveExceptionMappingService().map("Cannot create folder {0}", e, folder);
        }
    }

    public boolean isSupported(Path workdir, String name) {
        return true;
    }

    public DriveDirectoryFeature withWriter(Write<Void> writer) {
        return this;
    }
}

