/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.googledrive;

import ch.cyberduck.core.AbstractPath;
import ch.cyberduck.core.AttributedList;
import ch.cyberduck.core.DescriptiveUrl;
import ch.cyberduck.core.ListProgressListener;
import ch.cyberduck.core.ListService;
import ch.cyberduck.core.LocaleFactory;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathAttributes;
import ch.cyberduck.core.PathNormalizer;
import ch.cyberduck.core.Referenceable;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.googledrive.DriveExceptionMappingService;
import ch.cyberduck.core.googledrive.DriveSession;
import ch.cyberduck.core.io.Checksum;
import ch.cyberduck.core.preferences.PreferencesFactory;
import ch.cyberduck.core.webloc.UrlFileWriter;
import ch.cyberduck.core.webloc.UrlFileWriterFactory;
import com.google.api.services.drive.Drive;
import com.google.api.services.drive.model.File;
import com.google.api.services.drive.model.FileList;
import java.io.IOException;
import java.net.URI;
import java.nio.charset.Charset;
import java.text.MessageFormat;
import java.util.EnumSet;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public abstract class AbstractDriveListService
implements ListService {
    private static final Logger log = Logger.getLogger(AbstractDriveListService.class);
    protected static final String GOOGLE_APPS_PREFIX = "application/vnd.google-apps";
    protected static final String DRIVE_FOLDER = String.format("%s.folder", "application/vnd.google-apps");
    protected static final String DEFAULT_FIELDS = "files(createdTime,explicitlyTrashed,id,md5Checksum,mimeType,modifiedTime,name,size,webViewLink),nextPageToken";
    private final DriveSession session;
    private final int pagesize;
    private final UrlFileWriter urlFileWriter = UrlFileWriterFactory.get();
    private final String fields;

    public AbstractDriveListService(DriveSession session) {
        this(session, PreferencesFactory.get().getInteger("googledrive.list.limit"));
    }

    public AbstractDriveListService(DriveSession session, int pagesize) {
        this(session, pagesize, DEFAULT_FIELDS);
    }

    public AbstractDriveListService(DriveSession session, int pagesize, String fields) {
        this.session = session;
        this.pagesize = pagesize;
        this.fields = fields;
    }

    public AttributedList<Path> list(Path directory, ListProgressListener listener) throws BackgroundException {
        try {
            AttributedList children = new AttributedList();
            String page = null;
            do {
                FileList list = (FileList)((Drive)this.session.getClient()).files().list().setIncludeTeamDriveItems(Boolean.valueOf(true)).setSupportsTeamDrives(Boolean.valueOf(PreferencesFactory.get().getBoolean("googledrive.teamdrive.enable"))).setQ(this.query(directory, listener)).setOrderBy("name").setPageToken(page).setFields(this.fields).setPageSize(Integer.valueOf(this.pagesize)).execute();
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("Chunk of %d retrieved", list.getFiles().size()));
                }
                for (File f : list.getFiles()) {
                    PathAttributes properties = this.toAttributes(f);
                    String filename = !DRIVE_FOLDER.equals(f.getMimeType()) && StringUtils.startsWith((CharSequence)f.getMimeType(), (CharSequence)GOOGLE_APPS_PREFIX) ? String.format("%s.%s", PathNormalizer.name((String)f.getName()), this.urlFileWriter.getExtension()) : PathNormalizer.name((String)f.getName());
                    if (StringUtils.equals((CharSequence)filename, (CharSequence)String.valueOf('/'))) continue;
                    EnumSet<AbstractPath.Type> type = DRIVE_FOLDER.equals(f.getMimeType()) ? EnumSet.of(AbstractPath.Type.directory) : (StringUtils.startsWith((CharSequence)f.getMimeType(), (CharSequence)GOOGLE_APPS_PREFIX) ? EnumSet.of(AbstractPath.Type.file, AbstractPath.Type.placeholder) : EnumSet.of(AbstractPath.Type.file));
                    Path child = new Path(directory, filename, type, properties);
                    children.add((Referenceable)child);
                }
                listener.chunk(directory, children);
                page = list.getNextPageToken();
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)String.format("Continue with next page token %s", page));
            } while (page != null);
            return children;
        }
        catch (IOException e) {
            throw new DriveExceptionMappingService().map("Listing directory failed", e, directory);
        }
    }

    protected PathAttributes toAttributes(File f) {
        PathAttributes attributes = new PathAttributes();
        if (null != f.getExplicitlyTrashed() && f.getExplicitlyTrashed().booleanValue()) {
            attributes.setDuplicate(true);
        }
        if (null != f.getSize() && !DRIVE_FOLDER.equals(f.getMimeType()) && !StringUtils.startsWith((CharSequence)f.getMimeType(), (CharSequence)GOOGLE_APPS_PREFIX)) {
            attributes.setSize(f.getSize().longValue());
        }
        attributes.setVersionId(f.getId());
        if (f.getModifiedTime() != null) {
            attributes.setModificationDate(f.getModifiedTime().getValue());
        }
        if (f.getCreatedTime() != null) {
            attributes.setCreationDate(f.getCreatedTime().getValue());
        }
        attributes.setChecksum(Checksum.parse((String)f.getMd5Checksum()));
        if (StringUtils.isNotBlank((CharSequence)f.getWebViewLink())) {
            attributes.setLink(new DescriptiveUrl(URI.create(f.getWebViewLink()), DescriptiveUrl.Type.http, MessageFormat.format(LocaleFactory.localizedString((String)"{0} URL"), "HTTP")));
            if (!DRIVE_FOLDER.equals(f.getMimeType()) && StringUtils.startsWith((CharSequence)f.getMimeType(), (CharSequence)GOOGLE_APPS_PREFIX)) {
                attributes.setSize((long)UrlFileWriterFactory.get().write(new DescriptiveUrl(URI.create(f.getWebViewLink()))).getBytes(Charset.defaultCharset()).length);
            }
        }
        return attributes;
    }

    protected abstract String query(Path var1, ListProgressListener var2) throws BackgroundException;
}

