/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.onedrive;

import ch.cyberduck.core.DefaultIOExceptionMappingService;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.Touch;
import ch.cyberduck.core.features.Write;
import ch.cyberduck.core.onedrive.OneDriveExceptionMappingService;
import ch.cyberduck.core.onedrive.OneDriveSession;
import ch.cyberduck.core.transfer.TransferStatus;
import java.io.IOException;
import org.apache.commons.lang3.StringUtils;
import org.nuxeo.onedrive.client.OneDriveAPIException;

public class OneDriveTouchFeature
implements Touch<Void> {
    private final OneDriveSession session;

    public OneDriveTouchFeature(OneDriveSession session) {
        this.session = session;
    }

    public Path touch(Path file, TransferStatus status) throws BackgroundException {
        try {
            this.session.toFile(file).create(StringUtils.isNotBlank((CharSequence)status.getMime()) ? status.getMime() : "application/octet-stream");
        }
        catch (OneDriveAPIException e) {
            throw new OneDriveExceptionMappingService().map("Cannot create file {0}", e, file);
        }
        catch (IOException e) {
            throw new DefaultIOExceptionMappingService().map("Cannot create file {0}", (Throwable)e, file);
        }
        return file;
    }

    public boolean isSupported(Path workdir) {
        return !workdir.isRoot();
    }

    public Touch<Void> withWriter(Write writer) {
        return this;
    }
}

