/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.transfer.synchronisation;

import ch.cyberduck.core.Cache;
import ch.cyberduck.core.Local;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.ProgressListener;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.synchronization.ComparePathFilter;
import ch.cyberduck.core.synchronization.Comparison;
import ch.cyberduck.core.transfer.TransferAction;
import ch.cyberduck.core.transfer.TransferOptions;
import ch.cyberduck.core.transfer.TransferPathFilter;
import ch.cyberduck.core.transfer.TransferStatus;
import org.apache.log4j.Logger;

public class SynchronizationPathFilter
implements TransferPathFilter {
    private static final Logger log = Logger.getLogger(SynchronizationPathFilter.class);
    private final ComparePathFilter comparison;
    private final TransferPathFilter downloadFilter;
    private final TransferPathFilter uploadFilter;
    private TransferAction action = TransferAction.mirror;

    public SynchronizationPathFilter(ComparePathFilter comparison, TransferPathFilter downloadFilter, TransferPathFilter uploadFilter, TransferAction action) {
        this.comparison = comparison;
        this.downloadFilter = downloadFilter;
        this.uploadFilter = uploadFilter;
        this.action = action;
    }

    @Override
    public TransferPathFilter withCache(Cache<Path> cache) {
        this.downloadFilter.withCache(cache);
        this.uploadFilter.withCache(cache);
        return this;
    }

    @Override
    public TransferStatus prepare(Path file, Local local, TransferStatus parent, ProgressListener progress) throws BackgroundException {
        Comparison compare = this.comparison.compare(file, local);
        if (compare.equals((Object)Comparison.remote)) {
            return this.downloadFilter.prepare(file, local, parent, progress);
        }
        if (compare.equals((Object)Comparison.local)) {
            return this.uploadFilter.prepare(file, local, parent, progress);
        }
        return this.uploadFilter.prepare(file, local, parent, progress).exists(true);
    }

    @Override
    public boolean accept(Path file, Local local, TransferStatus parent) throws BackgroundException {
        Comparison compare = this.comparison.compare(file, local);
        if (compare.equals((Object)Comparison.equal)) {
            return file.isDirectory();
        }
        if (compare.equals((Object)Comparison.remote)) {
            if (this.action.equals(TransferAction.upload)) {
                if (log.isInfoEnabled()) {
                    log.info((Object)String.format("Skip file %s with comparison result %s because action is %s", new Object[]{file, compare, this.action}));
                }
                return false;
            }
            return this.downloadFilter.accept(file, local, parent);
        }
        if (compare.equals((Object)Comparison.local)) {
            if (this.action.equals(TransferAction.download)) {
                if (log.isInfoEnabled()) {
                    log.info((Object)String.format("Skip file %s with comparison result %s because action is %s", new Object[]{file, compare, this.action}));
                }
                return false;
            }
            return this.uploadFilter.accept(file, local, parent);
        }
        log.warn((Object)String.format("Invalid comparison %s", new Object[]{compare}));
        return false;
    }

    @Override
    public void apply(Path file, Local local, TransferStatus status, ProgressListener listener) throws BackgroundException {
        Comparison compare = this.comparison.compare(file, local);
        if (compare.equals((Object)Comparison.remote)) {
            this.downloadFilter.apply(file, local, status, listener);
        } else if (compare.equals((Object)Comparison.local)) {
            this.uploadFilter.apply(file, local, status, listener);
        }
    }

    @Override
    public void complete(Path file, Local local, TransferOptions options, TransferStatus status, ProgressListener listener) throws BackgroundException {
        Comparison compare = this.comparison.compare(file, local);
        if (compare.equals((Object)Comparison.remote)) {
            this.downloadFilter.complete(file, local, options, status, listener);
        } else if (compare.equals((Object)Comparison.local)) {
            this.uploadFilter.complete(file, local, options, status, listener);
        }
    }
}

