/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.shared;

import ch.cyberduck.core.Cache;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathAttributes;
import ch.cyberduck.core.PathCache;
import ch.cyberduck.core.Session;
import ch.cyberduck.core.exception.AccessDeniedException;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.exception.InteroperabilityException;
import ch.cyberduck.core.exception.NotfoundException;
import ch.cyberduck.core.features.AttributesFinder;
import ch.cyberduck.core.shared.ListFilteringFeature;
import org.apache.log4j.Logger;

public class DefaultAttributesFinderFeature
extends ListFilteringFeature
implements AttributesFinder {
    private static final Logger log = Logger.getLogger(DefaultAttributesFinderFeature.class);
    private final Session<?> session;
    private Cache<Path> cache = PathCache.empty();

    public DefaultAttributesFinderFeature(Session<?> session) {
        super(session);
        this.session = session;
    }

    @Override
    public PathAttributes find(Path file) throws BackgroundException {
        if (file.isRoot()) {
            return PathAttributes.EMPTY;
        }
        try {
            Path found = this.search(file);
            if (null == found) {
                throw new NotfoundException(file.getAbsolute());
            }
            return found.attributes();
        }
        catch (AccessDeniedException | InteroperabilityException | NotfoundException f) {
            log.warn((Object)String.format("Failure listing directory %s. %s", file.getParent(), f.getMessage()));
            AttributesFinder feature = this.session._getFeature(AttributesFinder.class);
            if (feature instanceof DefaultAttributesFinderFeature) {
                throw f;
            }
            return feature.withCache(this.cache).find(file);
        }
    }

    @Override
    public DefaultAttributesFinderFeature withCache(Cache<Path> cache) {
        this.cache = cache;
        super.withCache(cache);
        return this;
    }
}

