/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core;

import ch.cyberduck.core.LocaleFactory;
import java.net.URI;

public class DescriptiveUrl {
    public static final DescriptiveUrl EMPTY = new DescriptiveUrl(null);
    private final URI url;
    private final Type type;
    private String help = "";

    public DescriptiveUrl(URI url) {
        this(url, Type.http, LocaleFactory.localizedString("Open in Web Browser"));
    }

    public DescriptiveUrl(URI url, Type type) {
        this(url, type, LocaleFactory.localizedString("Open in Web Browser"));
    }

    public DescriptiveUrl(URI url, Type type, String help) {
        this.url = url;
        this.type = type;
        this.help = help;
    }

    public String getUrl() {
        if (null == this.url) {
            return null;
        }
        return this.url.toString();
    }

    public Type getType() {
        return this.type;
    }

    public String getHelp() {
        return this.help;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DescriptiveUrl that = (DescriptiveUrl)o;
        if (this.type != that.type) {
            return false;
        }
        return !(this.url != null ? !this.url.equals(that.url) : that.url != null);
    }

    public int hashCode() {
        int result = this.url != null ? this.url.hashCode() : 0;
        result = 31 * result + (this.type != null ? this.type.hashCode() : 0);
        return result;
    }

    public String toString() {
        return this.getUrl();
    }

    public static enum Type {
        provider,
        http,
        cdn,
        origin,
        cname,
        signed,
        torrent,
        authenticated,
        analytics,
        encrypted;

    }
}

