/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core;

import ch.cyberduck.core.AttributedListAttributes;
import ch.cyberduck.core.Filter;
import ch.cyberduck.core.Referenceable;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Predicate;
import org.apache.log4j.Logger;

public class AttributedList<E extends Referenceable>
implements Iterable<E> {
    private static final Logger log = Logger.getLogger(AttributedList.class);
    private static final AttributedList EMPTY = new AttributedList(){

        public boolean add(Referenceable o) {
            throw new UnsupportedOperationException();
        }

        public void add(int index, Referenceable element) {
            throw new UnsupportedOperationException();
        }

        public boolean addAll(Iterable c) {
            throw new UnsupportedOperationException();
        }
    };
    private final List<E> impl = new CopyOnWriteArrayList();
    private final AttributedListAttributes<E> attributes = new AttributedListAttributes().withTimestamp(System.currentTimeMillis());

    public AttributedList() {
    }

    public AttributedList(Iterable<E> collection) {
        for (Referenceable e : collection) {
            this.add(e);
        }
    }

    public static <T extends Referenceable> AttributedList<T> emptyList() {
        return EMPTY;
    }

    public AttributedListAttributes<E> attributes() {
        return this.attributes;
    }

    public boolean add(E e) {
        if (this.attributes.getFilter().accept(e)) {
            return this.impl.add(e);
        }
        return this.attributes.getHidden().add(e);
    }

    public void add(int index, E e) {
        this.impl.add(index, e);
    }

    public boolean addAll(Iterable<? extends E> c) {
        for (Referenceable file : c) {
            this.add(file);
        }
        return true;
    }

    public E get(int index) {
        return (E)((Referenceable)this.impl.get(index));
    }

    public E get(E reference) {
        int index = this.impl.indexOf(reference);
        if (-1 == index) {
            return null;
        }
        return (E)((Referenceable)this.impl.get(index));
    }

    public void set(int i, E e) {
        this.impl.set(i, e);
    }

    @Override
    public Iterator<E> iterator() {
        return this.impl.iterator();
    }

    private void doSort(Comparator<E> comparator) {
        if (null == comparator) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Sort list %s with comparator %s", this, comparator));
        }
        Collections.sort(this.impl, comparator);
    }

    public AttributedList<E> filter(Filter<E> filter) {
        return this.filter(null, filter);
    }

    public AttributedList<E> filter(Comparator<E> comparator) {
        return this.filter(comparator, null);
    }

    public AttributedList<E> filter(Comparator<E> comparator, final Filter<E> filter) {
        boolean needsSorting = false;
        if (null != comparator) {
            needsSorting = !this.attributes.getComparator().equals(comparator);
        }
        boolean needsFiltering = false;
        if (null != filter) {
            boolean bl = needsFiltering = !this.attributes.getFilter().equals(filter);
        }
        if (needsSorting) {
            if (!needsFiltering) {
                this.doSort(comparator);
            }
            this.attributes.setComparator(comparator);
        }
        if (needsFiltering) {
            List<E> hidden;
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("Filter list %s with filter %s", this, filter));
            }
            if (!(hidden = this.attributes.getHidden()).isEmpty()) {
                this.impl.addAll(hidden);
                hidden.clear();
            }
            this.impl.removeIf(new Predicate<E>(){

                @Override
                public boolean test(E e) {
                    boolean accept = filter.accept(e);
                    if (!accept) {
                        AttributedList.this.attributes.addHidden(e);
                    }
                    return !accept;
                }
            });
            this.attributes.setFilter(filter);
            this.doSort(comparator);
        }
        return this;
    }

    public void clear() {
        this.attributes.clear();
        this.impl.clear();
    }

    public boolean isEmpty() {
        return this.impl.isEmpty();
    }

    public int size() {
        return this.impl.size();
    }

    public boolean contains(E e) {
        return this.impl.contains(e);
    }

    public E find(Predicate<E> predicate) {
        Optional optional = this.impl.stream().filter(predicate).findFirst();
        return (E)((Referenceable)optional.orElse(null));
    }

    public E[] toArray() {
        return this.impl.toArray(new Referenceable[this.impl.size()]);
    }

    public List<E> toList() {
        return this.impl;
    }

    public int indexOf(E e) {
        return this.impl.indexOf(e);
    }

    public boolean remove(E e) {
        return this.impl.remove(e);
    }

    public boolean removeAll(Collection<E> e) {
        return this.impl.removeAll(e);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AttributedList that = (AttributedList)o;
        return Objects.equals(this.impl, that.impl);
    }

    public int hashCode() {
        return Objects.hash(this.impl);
    }
}

