/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.b2;

import ch.cyberduck.core.AttributedList;
import ch.cyberduck.core.Cache;
import ch.cyberduck.core.DefaultIOExceptionMappingService;
import ch.cyberduck.core.DisabledListProgressListener;
import ch.cyberduck.core.Filter;
import ch.cyberduck.core.ListProgressListener;
import ch.cyberduck.core.NullFilter;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathCache;
import ch.cyberduck.core.PathContainerService;
import ch.cyberduck.core.Referenceable;
import ch.cyberduck.core.SimplePathPredicate;
import ch.cyberduck.core.b2.B2ExceptionMappingService;
import ch.cyberduck.core.b2.B2ListService;
import ch.cyberduck.core.b2.B2PathContainerService;
import ch.cyberduck.core.b2.B2Session;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.exception.NotfoundException;
import ch.cyberduck.core.features.IdProvider;
import java.io.IOException;
import java.util.function.Predicate;
import org.apache.commons.lang3.StringUtils;
import synapticloop.b2.B2ApiClient;
import synapticloop.b2.exception.B2ApiException;
import synapticloop.b2.response.B2FileInfoResponse;
import synapticloop.b2.response.B2ListFilesResponse;

public class B2FileidProvider
implements IdProvider {
    private final PathContainerService containerService = new B2PathContainerService();
    private final B2Session session;
    private Cache<Path> cache = PathCache.empty();

    public B2FileidProvider(B2Session session) {
        this.session = session;
    }

    public String getFileid(Path file, ListProgressListener listener) throws BackgroundException {
        if (StringUtils.isNotBlank((CharSequence)file.attributes().getVersionId())) {
            return file.attributes().getVersionId();
        }
        if (this.containerService.isContainer(file)) {
            AttributedList<Path> list;
            if (!this.cache.isCached((Referenceable)file.getParent())) {
                list = new B2ListService(this.session, this).list(file.getParent(), (ListProgressListener)new DisabledListProgressListener());
                this.cache.put((Referenceable)file.getParent(), list);
            } else {
                list = this.cache.get((Referenceable)file.getParent());
            }
            Path found = (Path)list.filter((Filter)new NullFilter()).find((Predicate)new SimplePathPredicate(file));
            if (null == found) {
                throw new NotfoundException(file.getAbsolute());
            }
            return found.attributes().getVersionId();
        }
        try {
            B2ListFilesResponse response = ((B2ApiClient)this.session.getClient()).listFileNames(this.getFileid(this.containerService.getContainer(file), listener), this.containerService.getKey(file), Integer.valueOf(2));
            for (B2FileInfoResponse info : response.getFiles()) {
                if (!StringUtils.equals((CharSequence)this.containerService.getKey(file), (CharSequence)info.getFileName())) continue;
                return info.getFileId();
            }
            throw new NotfoundException(file.getAbsolute());
        }
        catch (B2ApiException e) {
            throw new B2ExceptionMappingService().map(e);
        }
        catch (IOException e) {
            throw new DefaultIOExceptionMappingService().map(e);
        }
    }

    public IdProvider withCache(Cache<Path> cache) {
        this.cache = cache;
        return this;
    }
}

