/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.b2;

import ch.cyberduck.core.AbstractPath;
import ch.cyberduck.core.DefaultIOExceptionMappingService;
import ch.cyberduck.core.DisabledListProgressListener;
import ch.cyberduck.core.ListProgressListener;
import ch.cyberduck.core.PasswordCallback;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathContainerService;
import ch.cyberduck.core.b2.B2ExceptionMappingService;
import ch.cyberduck.core.b2.B2FileidProvider;
import ch.cyberduck.core.b2.B2LargeUploadPartService;
import ch.cyberduck.core.b2.B2PathContainerService;
import ch.cyberduck.core.b2.B2Session;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.exception.NotfoundException;
import ch.cyberduck.core.features.Delete;
import java.io.IOException;
import java.util.List;
import org.apache.log4j.Logger;
import synapticloop.b2.B2ApiClient;
import synapticloop.b2.exception.B2ApiException;

public class B2DeleteFeature
implements Delete {
    private static final Logger log = Logger.getLogger(B2DeleteFeature.class);
    private final PathContainerService containerService = new B2PathContainerService();
    private final B2Session session;

    public B2DeleteFeature(B2Session session) {
        this.session = session;
    }

    public void delete(List<Path> files, PasswordCallback prompt, Delete.Callback callback) throws BackgroundException {
        for (Path file : files) {
            if (this.containerService.isContainer(file)) continue;
            callback.delete(file);
            if (file.getType().contains(AbstractPath.Type.upload)) {
                new B2LargeUploadPartService(this.session).delete(file.attributes().getVersionId());
                continue;
            }
            if (file.isDirectory()) {
                String fileid;
                try {
                    fileid = new B2FileidProvider(this.session).getFileid(file, (ListProgressListener)new DisabledListProgressListener());
                }
                catch (NotfoundException e) {
                    log.warn((Object)String.format("Ignore failure %s deleting placeholder file for %s", e.getDetail(), file));
                    continue;
                }
                try {
                    ((B2ApiClient)this.session.getClient()).deleteFileVersion(this.containerService.getKey(file), fileid);
                    continue;
                }
                catch (B2ApiException e) {
                    log.warn((Object)String.format("Ignore failure %s deleting placeholder file for %s", e.getMessage(), file));
                    continue;
                }
                catch (IOException e) {
                    throw new DefaultIOExceptionMappingService().map(e);
                }
            }
            if (!file.isFile()) continue;
            try {
                ((B2ApiClient)this.session.getClient()).deleteFileVersion(this.containerService.getKey(file), new B2FileidProvider(this.session).getFileid(file, (ListProgressListener)new DisabledListProgressListener()));
            }
            catch (B2ApiException e) {
                throw new B2ExceptionMappingService().map("Cannot delete {0}", e, file);
            }
            catch (IOException e) {
                throw new DefaultIOExceptionMappingService().map(e);
            }
        }
        for (Path file : files) {
            try {
                if (!this.containerService.isContainer(file)) continue;
                callback.delete(file);
                ((B2ApiClient)this.session.getClient()).deleteBucket(new B2FileidProvider(this.session).getFileid(file, (ListProgressListener)new DisabledListProgressListener()));
            }
            catch (B2ApiException e) {
                throw new B2ExceptionMappingService().map("Cannot delete {0}", e, file);
            }
            catch (IOException e) {
                throw new DefaultIOExceptionMappingService().map(e);
            }
        }
    }

    public boolean isSupported(Path file) {
        return true;
    }

    public boolean isRecursive() {
        return false;
    }
}

