/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.b2;

import ch.cyberduck.core.Acl;
import ch.cyberduck.core.DefaultIOExceptionMappingService;
import ch.cyberduck.core.DisabledListProgressListener;
import ch.cyberduck.core.ListProgressListener;
import ch.cyberduck.core.LocaleFactory;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathContainerService;
import ch.cyberduck.core.b2.B2ExceptionMappingService;
import ch.cyberduck.core.b2.B2FileidProvider;
import ch.cyberduck.core.b2.B2PathContainerService;
import ch.cyberduck.core.b2.B2Session;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.AclPermission;
import ch.cyberduck.core.features.Location;
import ch.cyberduck.core.shared.DefaultAclFeature;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.jets3t.service.acl.Permission;
import synapticloop.b2.B2ApiClient;
import synapticloop.b2.BucketType;
import synapticloop.b2.LifecycleRule;
import synapticloop.b2.exception.B2ApiException;

public class B2BucketTypeFeature
extends DefaultAclFeature
implements AclPermission,
Location {
    private final PathContainerService containerService = new B2PathContainerService();
    private final B2Session session;

    public B2BucketTypeFeature(B2Session session) {
        this.session = session;
    }

    public Acl getPermission(Path file) throws BackgroundException {
        if (this.containerService.isContainer(file)) {
            return this.containerService.getContainer(file).attributes().getAcl();
        }
        return Acl.EMPTY;
    }

    public void setPermission(Path file, Acl acl) throws BackgroundException {
        if (this.containerService.isContainer(file)) {
            try {
                BucketType bucketType = this.convert(acl);
                ((B2ApiClient)this.session.getClient()).updateBucket(new B2FileidProvider(this.session).getFileid(this.containerService.getContainer(file), (ListProgressListener)new DisabledListProgressListener()), bucketType, new LifecycleRule[0]);
            }
            catch (B2ApiException e) {
                throw new B2ExceptionMappingService().map("Cannot change permissions of {0}", e, file);
            }
            catch (IOException e) {
                throw new DefaultIOExceptionMappingService().map(e);
            }
        }
    }

    protected BucketType convert(Acl acl) {
        BucketType bucketType = BucketType.allPrivate;
        for (Acl.UserAndRole userAndRole : acl.asList()) {
            if (!(userAndRole.getUser() instanceof Acl.GroupUser) || !userAndRole.getUser().getIdentifier().equals("AllUsers")) continue;
            bucketType = BucketType.allPublic;
            break;
        }
        return bucketType;
    }

    public List<Acl.User> getAvailableAclUsers() {
        return new ArrayList<Acl.GroupUser>(Collections.singletonList(new Acl.GroupUser("AllUsers", false)));
    }

    public List<Acl.Role> getAvailableAclRoles(List<Path> files) {
        return Collections.singletonList(new Acl.Role(Permission.PERMISSION_READ.toString()));
    }

    public Set<Location.Name> getLocations() {
        LinkedHashSet<Location.Name> types = new LinkedHashSet<Location.Name>();
        types.add(new B2BucketTypeName(BucketType.allPrivate));
        types.add(new B2BucketTypeName(BucketType.allPublic));
        return types;
    }

    public Location.Name getLocation(Path file) throws BackgroundException {
        Path container = this.containerService.getContainer(file);
        if (container.isRoot()) {
            return unknown;
        }
        for (Acl.UserAndRole role : container.attributes().getAcl().asList()) {
            if (!role.getUser().equals((Object)new Acl.GroupUser("AllUsers")) || !role.getRole().equals((Object)new Acl.Role("READ"))) continue;
            return new B2BucketTypeName(BucketType.allPublic);
        }
        return new B2BucketTypeName(BucketType.allPrivate);
    }

    public static final class B2BucketTypeName
    extends Location.Name {
        private final String description;

        public B2BucketTypeName(BucketType type) {
            super(type.name());
            switch (type) {
                case allPublic: {
                    this.description = LocaleFactory.localizedString((String)"Public", (String)"B2");
                    break;
                }
                case allPrivate: {
                    this.description = LocaleFactory.localizedString((String)"Private", (String)"B2");
                    break;
                }
                default: {
                    this.description = LocaleFactory.localizedString((String)"Unknown");
                }
            }
        }

        public String toString() {
            return this.description;
        }
    }
}

