/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.b2;

import ch.cyberduck.core.AbstractPath;
import ch.cyberduck.core.Acl;
import ch.cyberduck.core.AttributedList;
import ch.cyberduck.core.DefaultIOExceptionMappingService;
import ch.cyberduck.core.ListProgressListener;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathAttributes;
import ch.cyberduck.core.Referenceable;
import ch.cyberduck.core.RootListService;
import ch.cyberduck.core.b2.B2ExceptionMappingService;
import ch.cyberduck.core.b2.B2Session;
import ch.cyberduck.core.exception.BackgroundException;
import java.io.IOException;
import java.util.EnumSet;
import synapticloop.b2.B2ApiClient;
import synapticloop.b2.exception.B2ApiException;
import synapticloop.b2.response.B2BucketResponse;

public class B2BucketListService
implements RootListService {
    private final B2Session session;

    public B2BucketListService(B2Session session) {
        this.session = session;
    }

    public AttributedList<Path> list(Path directory, ListProgressListener listener) throws BackgroundException {
        try {
            AttributedList buckets = new AttributedList();
            for (B2BucketResponse bucket : ((B2ApiClient)this.session.getClient()).listBuckets()) {
                PathAttributes attributes = new PathAttributes();
                attributes.setVersionId(bucket.getBucketId());
                switch (bucket.getBucketType()) {
                    case allPublic: {
                        attributes.setAcl(new Acl((Acl.User)new Acl.GroupUser("AllUsers", false), new Acl.Role[]{new Acl.Role("READ")}));
                    }
                }
                buckets.add((Referenceable)new Path(bucket.getBucketName(), EnumSet.of(AbstractPath.Type.directory, AbstractPath.Type.volume), attributes));
            }
            listener.chunk(directory, buckets);
            return buckets;
        }
        catch (B2ApiException e) {
            throw new B2ExceptionMappingService().map("Listing directory {0} failed", e, directory);
        }
        catch (IOException e) {
            throw new DefaultIOExceptionMappingService().map(e);
        }
    }
}

