/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.irods;

import ch.cyberduck.core.AttributedList;
import ch.cyberduck.core.BookmarkNameProvider;
import ch.cyberduck.core.Credentials;
import ch.cyberduck.core.Host;
import ch.cyberduck.core.HostKeyCallback;
import ch.cyberduck.core.HostPasswordStore;
import ch.cyberduck.core.ListProgressListener;
import ch.cyberduck.core.LocaleFactory;
import ch.cyberduck.core.LoginCallback;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.URIEncoder;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.exception.LoginFailureException;
import ch.cyberduck.core.features.Copy;
import ch.cyberduck.core.features.Delete;
import ch.cyberduck.core.features.Directory;
import ch.cyberduck.core.features.Find;
import ch.cyberduck.core.features.Home;
import ch.cyberduck.core.features.Move;
import ch.cyberduck.core.features.Read;
import ch.cyberduck.core.features.Touch;
import ch.cyberduck.core.features.Write;
import ch.cyberduck.core.irods.IRODSCopyFeature;
import ch.cyberduck.core.irods.IRODSDeleteFeature;
import ch.cyberduck.core.irods.IRODSDirectoryFeature;
import ch.cyberduck.core.irods.IRODSExceptionMappingService;
import ch.cyberduck.core.irods.IRODSFindFeature;
import ch.cyberduck.core.irods.IRODSHomeFinderService;
import ch.cyberduck.core.irods.IRODSListService;
import ch.cyberduck.core.irods.IRODSMoveFeature;
import ch.cyberduck.core.irods.IRODSReadFeature;
import ch.cyberduck.core.irods.IRODSTouchFeature;
import ch.cyberduck.core.irods.IRODSWriteFeature;
import ch.cyberduck.core.preferences.Preferences;
import ch.cyberduck.core.preferences.PreferencesFactory;
import ch.cyberduck.core.proxy.Proxy;
import ch.cyberduck.core.ssl.DefaultX509KeyManager;
import ch.cyberduck.core.ssl.DisabledX509TrustManager;
import ch.cyberduck.core.ssl.SSLSession;
import ch.cyberduck.core.ssl.X509KeyManager;
import ch.cyberduck.core.threading.CancelCallback;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.MessageFormat;
import javax.net.ssl.X509TrustManager;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.irods.jargon.core.connection.AuthScheme;
import org.irods.jargon.core.connection.IRODSAccount;
import org.irods.jargon.core.connection.JargonProperties;
import org.irods.jargon.core.connection.SettableJargonProperties;
import org.irods.jargon.core.connection.auth.AuthResponse;
import org.irods.jargon.core.exception.JargonException;
import org.irods.jargon.core.pub.IRODSAccessObjectFactory;
import org.irods.jargon.core.pub.IRODSFileSystem;
import org.irods.jargon.core.pub.IRODSFileSystemAO;

public class IRODSSession
extends SSLSession<IRODSFileSystemAO> {
    private static final Logger log = Logger.getLogger(IRODSSession.class);
    private final Preferences preferences = PreferencesFactory.get();

    public IRODSSession(Host h) {
        super(h, (ch.cyberduck.core.ssl.X509TrustManager)new DisabledX509TrustManager(), (X509KeyManager)new DefaultX509KeyManager());
    }

    public IRODSSession(Host h, ch.cyberduck.core.ssl.X509TrustManager trust, X509KeyManager key) {
        super(h, trust, key);
    }

    protected IRODSFileSystemAO connect(Proxy proxy, HostKeyCallback key, LoginCallback prompt) throws BackgroundException {
        try {
            IRODSFileSystem fs = this.configure(IRODSFileSystem.instance());
            IRODSAccessObjectFactory factory = fs.getIRODSAccessObjectFactory();
            String region = this.getRegion();
            String resource = this.getResource();
            Credentials credentials = this.host.getCredentials();
            try {
                return factory.getIRODSFileSystemAO((IRODSAccount)new URIEncodingIRODSAccount(credentials.getUsername(), credentials.getPassword(), new IRODSHomeFinderService(this).find().getAbsolute(), region, resource));
            }
            catch (IllegalArgumentException e) {
                throw new LoginFailureException(e.getMessage(), (Throwable)e);
            }
        }
        catch (JargonException e) {
            throw new IRODSExceptionMappingService().map(e);
        }
    }

    protected IRODSFileSystem configure(IRODSFileSystem client) {
        SettableJargonProperties properties = new SettableJargonProperties(client.getJargonProperties());
        properties.setEncoding(this.host.getEncoding());
        int timeout = this.preferences.getInteger("connection.timeout.seconds") * 1000;
        properties.setIrodsSocketTimeout(timeout);
        properties.setIrodsParallelSocketTimeout(timeout);
        properties.setGetBufferSize(PreferencesFactory.get().getInteger("connection.chunksize"));
        properties.setPutBufferSize(PreferencesFactory.get().getInteger("connection.chunksize"));
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Configure client %s with properties %s", client, properties));
        }
        client.getIrodsSession().setJargonProperties((JargonProperties)properties);
        client.getIrodsSession().setX509TrustManager((X509TrustManager)this.trust);
        return client;
    }

    protected String getRegion() {
        if (StringUtils.contains((CharSequence)this.host.getRegion(), (int)58)) {
            return StringUtils.splitPreserveAllTokens((String)this.host.getRegion(), (char)':')[0];
        }
        return this.host.getRegion();
    }

    protected String getResource() {
        if (StringUtils.contains((CharSequence)this.host.getRegion(), (int)58)) {
            return StringUtils.splitPreserveAllTokens((String)this.host.getRegion(), (char)':')[1];
        }
        return "";
    }

    public void login(Proxy proxy, HostPasswordStore keychain, LoginCallback prompt, CancelCallback cancel) throws BackgroundException {
        try {
            IRODSAccount account = ((IRODSFileSystemAO)this.client).getIRODSAccount();
            Credentials credentials = this.host.getCredentials();
            account.setUserName(credentials.getUsername());
            account.setPassword(credentials.getPassword());
            AuthResponse response = ((IRODSFileSystemAO)this.client).getIRODSAccessObjectFactory().authenticateIRODSAccount(account);
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("Connected to %s", response.getStartupResponse()));
            }
            if (!response.isSuccessful()) {
                throw new LoginFailureException(MessageFormat.format(LocaleFactory.localizedString((String)"Login {0} with username and password", (String)"Credentials"), BookmarkNameProvider.toString((Host)this.host)));
            }
        }
        catch (JargonException e) {
            throw new IRODSExceptionMappingService().map(e);
        }
    }

    protected void logout() throws BackgroundException {
        try {
            ((IRODSFileSystemAO)this.client).getIRODSSession().closeSession();
        }
        catch (JargonException e) {
            throw new IRODSExceptionMappingService().map(e);
        }
    }

    public AttributedList<Path> list(Path directory, ListProgressListener listener) throws BackgroundException {
        return new IRODSListService(this).list(directory, listener);
    }

    public <T> T _getFeature(Class<T> type) {
        if (type == Directory.class) {
            return (T)new IRODSDirectoryFeature(this);
        }
        if (type == Find.class) {
            return (T)new IRODSFindFeature(this);
        }
        if (type == Delete.class) {
            return (T)new IRODSDeleteFeature(this);
        }
        if (type == Read.class) {
            return (T)new IRODSReadFeature(this);
        }
        if (type == Move.class) {
            return (T)new IRODSMoveFeature(this);
        }
        if (type == Write.class) {
            return (T)((Object)new IRODSWriteFeature(this));
        }
        if (type == Touch.class) {
            return (T)new IRODSTouchFeature(this);
        }
        if (type == Copy.class) {
            return (T)new IRODSCopyFeature(this);
        }
        if (type == Home.class) {
            return (T)((Object)new IRODSHomeFinderService(this));
        }
        return (T)super._getFeature(type);
    }

    private final class URIEncodingIRODSAccount
    extends IRODSAccount {
        public URIEncodingIRODSAccount(String user, String password, String home, String region, String resource) {
            super(IRODSSession.this.host.getHostname(), IRODSSession.this.host.getPort(), StringUtils.isBlank((CharSequence)user) ? "" : user, password, home, region, resource);
            this.setUserName(user);
        }

        public URI toURI(boolean includePassword) throws JargonException {
            try {
                return new URI(String.format("irods://%s.%s%s@%s:%d%s", this.getUserName(), this.getZone(), includePassword ? String.format(":%s", this.getPassword()) : "", this.getHost(), this.getPort(), URIEncoder.encode((String)this.getHomeDirectory())));
            }
            catch (URISyntaxException e) {
                throw new JargonException(e.getMessage());
            }
        }

        public void setUserName(String input) {
            AuthScheme scheme;
            String user;
            if (StringUtils.contains((CharSequence)input, (int)58)) {
                user = StringUtils.splitPreserveAllTokens((String)input, (char)':')[1];
                scheme = AuthScheme.findTypeByString((String)StringUtils.splitPreserveAllTokens((String)input, (char)':')[0]);
            } else {
                user = input;
                scheme = StringUtils.isNotBlank((CharSequence)IRODSSession.this.host.getProtocol().getAuthorization()) ? AuthScheme.findTypeByString((String)IRODSSession.this.host.getProtocol().getAuthorization()) : AuthScheme.STANDARD;
            }
            super.setUserName(user);
            this.setAuthenticationScheme(scheme);
        }
    }
}

