/*
 * Decompiled with CFR 0.152.
 */
package sun.security.krb5.internal;

import java.io.IOException;
import sun.security.krb5.Credentials;
import sun.security.krb5.KrbException;
import sun.security.krb5.KrbTgsReq;
import sun.security.krb5.PrincipalName;
import sun.security.krb5.Realm;
import sun.security.krb5.internal.Krb5;
import sun.security.krb5.internal.KrbApErrException;
import sun.security.krb5.internal.PAData;
import sun.security.krb5.internal.PAForUserEnc;
import sun.security.krb5.internal.Ticket;

public class CredentialsUtil {
    private static boolean DEBUG = Krb5.DEBUG;

    public static Credentials acquireS4U2selfCreds(PrincipalName principalName, Credentials credentials) throws KrbException, IOException {
        String string;
        String string2 = principalName.getRealmString();
        if (!string2.equals(string = credentials.getClient().getRealmString())) {
            throw new KrbException("Cross realm impersonation not supported");
        }
        if (!credentials.isForwardable()) {
            throw new KrbException("S4U2self needs a FORWARDABLE ticket");
        }
        KrbTgsReq krbTgsReq = new KrbTgsReq(credentials, credentials.getClient(), new PAData(129, new PAForUserEnc(principalName, credentials.getSessionKey()).asn1Encode()));
        Credentials credentials2 = krbTgsReq.sendAndGetCreds();
        if (!credentials2.getClient().equals(principalName)) {
            throw new KrbException("S4U2self request not honored by KDC");
        }
        if (!credentials2.isForwardable()) {
            throw new KrbException("S4U2self ticket must be FORWARDABLE");
        }
        return credentials2;
    }

    public static Credentials acquireS4U2proxyCreds(String string, Ticket ticket, PrincipalName principalName, Credentials credentials) throws KrbException, IOException {
        KrbTgsReq krbTgsReq = new KrbTgsReq(credentials, ticket, new PrincipalName(string));
        Credentials credentials2 = krbTgsReq.sendAndGetCreds();
        if (!credentials2.getClient().equals(principalName)) {
            throw new KrbException("S4U2proxy request not honored by KDC");
        }
        return credentials2;
    }

    public static Credentials acquireServiceCreds(String string, Credentials credentials) throws KrbException, IOException {
        PrincipalName principalName = new PrincipalName(string);
        String string2 = principalName.getRealmString();
        String string3 = credentials.getClient().getRealmString();
        if (string3.equals(string2)) {
            if (DEBUG) {
                System.out.println(">>> Credentials acquireServiceCreds: same realm");
            }
            return CredentialsUtil.serviceCreds(principalName, credentials);
        }
        Credentials credentials2 = null;
        boolean[] blArray = new boolean[1];
        Credentials credentials3 = CredentialsUtil.getTGTforRealm(string3, string2, credentials, blArray);
        if (credentials3 != null) {
            if (DEBUG) {
                System.out.println(">>> Credentials acquireServiceCreds: got right tgt");
                System.out.println(">>> Credentials acquireServiceCreds: obtaining service creds for " + principalName);
            }
            try {
                credentials2 = CredentialsUtil.serviceCreds(principalName, credentials3);
            }
            catch (Exception exception) {
                if (DEBUG) {
                    System.out.println(exception);
                }
                credentials2 = null;
            }
        }
        if (credentials2 != null) {
            if (DEBUG) {
                System.out.println(">>> Credentials acquireServiceCreds: returning creds:");
                Credentials.printDebug(credentials2);
            }
            if (!blArray[0]) {
                credentials2.resetDelegate();
            }
            return credentials2;
        }
        throw new KrbApErrException(63, "No service creds");
    }

    private static Credentials getTGTforRealm(String string, String string2, Credentials credentials, boolean[] blArray) throws KrbException {
        String[] stringArray = Realm.getRealmsList(string, string2);
        int n = 0;
        int n2 = 0;
        Credentials credentials2 = null;
        Credentials credentials3 = null;
        Credentials credentials4 = null;
        PrincipalName principalName = null;
        String string3 = null;
        blArray[0] = true;
        credentials2 = credentials;
        n = 0;
        while (n < stringArray.length) {
            principalName = PrincipalName.tgsService(string2, stringArray[n]);
            if (DEBUG) {
                System.out.println(">>> Credentials acquireServiceCreds: main loop: [" + n + "] tempService=" + principalName);
            }
            try {
                credentials3 = CredentialsUtil.serviceCreds(principalName, credentials2);
            }
            catch (Exception exception) {
                credentials3 = null;
            }
            if (credentials3 == null) {
                if (DEBUG) {
                    System.out.println(">>> Credentials acquireServiceCreds: no tgt; searching thru capath");
                }
                credentials3 = null;
                for (n2 = n + 1; credentials3 == null && n2 < stringArray.length; ++n2) {
                    principalName = PrincipalName.tgsService(stringArray[n2], stringArray[n]);
                    if (DEBUG) {
                        System.out.println(">>> Credentials acquireServiceCreds: inner loop: [" + n2 + "] tempService=" + principalName);
                    }
                    try {
                        credentials3 = CredentialsUtil.serviceCreds(principalName, credentials2);
                        continue;
                    }
                    catch (Exception exception) {
                        credentials3 = null;
                    }
                }
            }
            if (credentials3 == null) {
                if (!DEBUG) break;
                System.out.println(">>> Credentials acquireServiceCreds: no tgt; cannot get creds");
                break;
            }
            string3 = credentials3.getServer().getInstanceComponent();
            if (blArray[0] && !credentials3.checkDelegate()) {
                if (DEBUG) {
                    System.out.println(">>> Credentials acquireServiceCreds: global OK-AS-DELEGATE turned off at " + credentials3.getServer());
                }
                blArray[0] = false;
            }
            if (DEBUG) {
                System.out.println(">>> Credentials acquireServiceCreds: got tgt");
            }
            if (string3.equals(string2)) {
                credentials4 = credentials3;
                break;
            }
            for (n2 = n + 1; n2 < stringArray.length && !string3.equals(stringArray[n2]); ++n2) {
            }
            if (n2 >= stringArray.length) break;
            n = n2;
            credentials2 = credentials3;
            if (!DEBUG) continue;
            System.out.println(">>> Credentials acquireServiceCreds: continuing with main loop counter reset to " + n);
        }
        return credentials4;
    }

    private static Credentials serviceCreds(PrincipalName principalName, Credentials credentials) throws KrbException, IOException {
        return new KrbTgsReq(credentials, principalName).sendAndGetCreds();
    }
}

