/*
 * Decompiled with CFR 0.152.
 */
package cc.mallet.grmm.util;

import bsh.EvalError;
import bsh.Interpreter;
import cc.mallet.grmm.types.Assignment;
import cc.mallet.grmm.types.BetaFactor;
import cc.mallet.grmm.types.BinaryUnaryFactor;
import cc.mallet.grmm.types.BoltzmannPairFactor;
import cc.mallet.grmm.types.BoltzmannUnaryFactor;
import cc.mallet.grmm.types.Factor;
import cc.mallet.grmm.types.FactorGraph;
import cc.mallet.grmm.types.PottsTableFactor;
import cc.mallet.grmm.types.UniNormalFactor;
import cc.mallet.grmm.types.UniformFactor;
import cc.mallet.grmm.types.VarSet;
import cc.mallet.grmm.types.Variable;
import gnu.trove.THashMap;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.regex.Pattern;

public class ModelReader {
    private static THashMap allClasses = new THashMap();
    private THashMap name2var = new THashMap();
    private static Pattern nbrRegex;

    public static Assignment readFromMatrix(VarSet vars, Reader in) throws IOException {
        String line;
        Variable[] varr = vars.toVariableArray();
        Interpreter interpreter = new Interpreter();
        BufferedReader bIn = new BufferedReader(in);
        Assignment assn = new Assignment();
        while ((line = bIn.readLine()) != null) {
            String[] fields = line.split("\\s+");
            Object[] vals = new Object[fields.length];
            for (int i = 0; i < fields.length; ++i) {
                try {
                    vals[i] = interpreter.eval(fields[i]);
                    continue;
                }
                catch (EvalError e) {
                    throw new RuntimeException("Error reading line: " + line, e);
                }
            }
            assn.addRow(varr, vals);
        }
        return assn;
    }

    public FactorGraph readModel(BufferedReader in) throws IOException {
        String line;
        ArrayList<Factor> factors = new ArrayList<Factor>();
        while ((line = in.readLine()) != null) {
            try {
                String[] fields = line.split("\\s+");
                if (fields[0].equalsIgnoreCase("VAR")) {
                    this.handleVariableDecl(fields);
                    continue;
                }
                Factor factor = this.factorFromLine(fields);
                factors.add(factor);
            }
            catch (Exception e) {
                throw new RuntimeException("Error reading line:\n" + line, e);
            }
        }
        FactorGraph fg = new FactorGraph();
        for (Factor factor : factors) {
            fg.multiplyBy(factor);
        }
        return fg;
    }

    private void handleVariableDecl(String[] fields) {
        int colonIdx = this.findColon(fields);
        if (fields.length != colonIdx + 2) {
            throw new IllegalArgumentException("Invalid syntax");
        }
        String numOutsString = fields[colonIdx + 1];
        int numOutcomes = numOutsString.equalsIgnoreCase("continuous") ? -1 : Integer.parseInt(numOutsString);
        for (int i = 0; i < colonIdx; ++i) {
            String name = fields[i];
            Variable var = new Variable(numOutcomes);
            var.setLabel(name);
            this.name2var.put((Object)name, (Object)var);
        }
    }

    private int findColon(String[] fields) {
        for (int i = 0; i < fields.length; ++i) {
            if (!fields[i].equals(":")) continue;
            return i;
        }
        throw new IllegalArgumentException("Invalid syntax.");
    }

    private Factor factorFromLine(String[] fields) {
        int idx = this.findTwiddle(fields);
        return this.constructFactor(fields, idx);
    }

    private int findTwiddle(String[] fields) {
        for (int i = 0; i < fields.length; ++i) {
            if (!fields[i].equals("~")) continue;
            return i;
        }
        return -1;
    }

    private Factor constructFactor(String[] fields, int idx) {
        Factor factor;
        Class factorClass = this.determineFactorClass(fields, idx);
        Object[] args = this.determineFactorArgs(fields, idx);
        Constructor factorCtor = this.findCtor(factorClass, args);
        try {
            factor = (Factor)factorCtor.newInstance(args);
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }
        return factor;
    }

    private Constructor findCtor(Class factorClass, Object[] args) {
        Class[] argClass = new Class[args.length];
        for (int i = 0; i < args.length; ++i) {
            argClass[i] = args[i].getClass();
            if (argClass[i] != Double.class) continue;
            argClass[i] = Double.TYPE;
        }
        try {
            return factorClass.getDeclaredConstructor(argClass);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException("Invalid arguments for factor " + factorClass);
        }
    }

    private Class determineFactorClass(String[] fields, int twiddleIdx) {
        String factorName = fields[twiddleIdx + 1].toLowerCase();
        Class theClass = (Class)allClasses.get((Object)factorName);
        if (theClass != null) {
            return theClass;
        }
        throw new RuntimeException("Could not determine factor class from " + factorName);
    }

    private Object[] determineFactorArgs(String[] fields, int twiddleIdx) {
        int i;
        ArrayList<Object> args = new ArrayList<Object>(fields.length);
        for (i = 0; i < twiddleIdx; ++i) {
            args.add(this.varFromName(fields[i], true));
        }
        for (i = twiddleIdx + 2; i < fields.length; ++i) {
            args.add(this.varFromName(fields[i], false));
        }
        return args.toArray();
    }

    private Object varFromName(String name, boolean preTwiddle) {
        if (nbrRegex.matcher(name).matches()) {
            return new Double(Double.parseDouble(name));
        }
        if (this.name2var.contains((Object)name)) {
            return this.name2var.get((Object)name);
        }
        Variable var = preTwiddle ? new Variable(2) : new Variable(-1);
        var.setLabel(name);
        this.name2var.put((Object)name, (Object)var);
        return var;
    }

    static {
        allClasses.put((Object)"potts", PottsTableFactor.class);
        allClasses.put((Object)"unary", BoltzmannUnaryFactor.class);
        allClasses.put((Object)"binaryunary", BinaryUnaryFactor.class);
        allClasses.put((Object)"binarypair", BoltzmannPairFactor.class);
        allClasses.put((Object)"uniform", UniformFactor.class);
        allClasses.put((Object)"normal", UniNormalFactor.class);
        allClasses.put((Object)"beta", BetaFactor.class);
        nbrRegex = Pattern.compile("[+-]?(\\d+(\\.[\\d]*)|\\.\\d+)");
    }
}

