/*
 * CDDL HEADER START
 *
 * The contents of this file are subject to the terms of the
 * Common Development and Distribution License (the "License").
 * You may not use this file except in compliance with the License.
 *
 * You can obtain a copy of the license at usr/src/OPENSOLARIS.LICENSE
 * or http://www.opensolaris.org/os/licensing.
 * See the License for the specific language governing permissions
 * and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL HEADER in each
 * file and include the License file at usr/src/OPENSOLARIS.LICENSE.
 * If applicable, add the following below this CDDL HEADER, with the
 * fields enclosed by brackets "[]" replaced with your own identifying
 * information: Portions Copyright [yyyy] [name of copyright owner]
 *
 * CDDL HEADER END
 */

/*
 * Copyright 2006 Sun Microsystems, Inc.  All rights reserved.
 * Use is subject to license terms.
 */

#pragma ident	"@(#)tst.vfork.d	1.1	06/08/28 SMI"

/*
 * ASSERTION: make sure probes called from a vfork(2) child fire in the parent
 *
 * SECTION: pid provider
 */

#pragma D option destructive

pid$1:a.out:waiting:entry
{
	this->value = (int *)alloca(sizeof (int));
	*this->value = 1;
	copyout(this->value, arg0, sizeof (int));
}

syscall::vfork:return
/curpsinfo->pr_ppid == $1/
{
	self->pid = pid;
}

pid$1:a.out:go:
/self->pid != pid/
{
	trace("wrong pid");
	exit(1);
}

#if !defined(__APPLE__)
syscall::rexit:entry
#else
syscall::exit:entry,proc:::lwp-exit
#endif
/pid == $1/
{
	exit(0);
}
