/*
 * CDDL HEADER START
 *
 * The contents of this file are subject to the terms of the
 * Common Development and Distribution License (the "License").
 * You may not use this file except in compliance with the License.
 *
 * You can obtain a copy of the license at usr/src/OPENSOLARIS.LICENSE
 * or http://www.opensolaris.org/os/licensing.
 * See the License for the specific language governing permissions
 * and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL HEADER in each
 * file and include the License file at usr/src/OPENSOLARIS.LICENSE.
 * If applicable, add the following below this CDDL HEADER, with the
 * fields enclosed by brackets "[]" replaced with your own identifying
 * information: Portions Copyright [yyyy] [name of copyright owner]
 *
 * CDDL HEADER END
 */

/*
 * Copyright 2008 Sun Microsystems, Inc.  All rights reserved.
 * Use is subject to license terms.
 */

/*	Copyright (c) 1988 AT&T	*/
/*	  All Rights Reserved  	*/

#pragma ident	"@(#)getphdr.c	1.12	08/05/31 SMI"

#include "libelf.h"
#include "decl.h"
#include "msg.h"


static void*
getphdr(Elf * elf, int class)
{
	void *	rc;
	if (elf == 0)
		return (0);
	ELFWLOCK(elf);
	if (elf->ed_class != class) {
		_elf_seterr(EREQ_CLASS, 0);
		ELFUNLOCK(elf);
		return (0);
	}
	if (elf->ed_phdr == 0)
		(void) _elf_cook(elf);
	rc = elf->ed_phdr;
	ELFUNLOCK(elf);
	return (rc);
}


Elf32_Phdr *
elf32_getphdr(Elf * elf)
{
	return ((Elf32_Phdr*) getphdr(elf, ELFCLASS32));
}

Elf64_Phdr *
elf64_getphdr(Elf * elf)
{
	return ((Elf64_Phdr*) getphdr(elf, ELFCLASS64));
}
